/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.network.toclient;

import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.client.ClientUUIDCache;
import de.srendi.advancedperipherals.network.IAPPacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class UsernameToCachePacket
implements IAPPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, UsernameToCachePacket> CODEC = StreamCodec.of((buffer, value) -> value.write((FriendlyByteBuf)buffer), UsernameToCachePacket::decode);
    public static final CustomPacketPayload.Type<UsernameToCachePacket> TYPE = new CustomPacketPayload.Type(AdvancedPeripherals.getRL("usernametocache"));
    public UUID uuid;
    public String username;

    public UsernameToCachePacket(UUID uuid, String username) {
        this.uuid = uuid;
        this.username = username;
    }

    public static UsernameToCachePacket decode(FriendlyByteBuf buffer) {
        return new UsernameToCachePacket(buffer.readUUID(), buffer.readUtf());
    }

    @Override
    public void handle(IPayloadContext context) {
        ClientUUIDCache.putUsername(this.uuid, this.username);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUtf(this.username);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

