/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.village;

import com.mojang.datafixers.util.Pair;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber(modid="advancedperipherals")
public class VillageStructures {
    private static void addPieceToPool(Registry<StructureTemplatePool> templatePoolRegistry, Holder<StructureProcessorList> emptyProcessor, ResourceLocation poolRL, String nbtPieceRL, StructureTemplatePool.Projection projection, int weight) {
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.get(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = poolRL.getPath().endsWith("streets") ? (SinglePoolElement)SinglePoolElement.legacy((String)nbtPieceRL, emptyProcessor).apply(projection) : (SinglePoolElement)SinglePoolElement.single((String)nbtPieceRL, emptyProcessor).apply(projection);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.rawTemplates);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.rawTemplates = listOfPieceEntries;
    }

    @SubscribeEvent
    public static void addStructures(ServerAboutToStartEvent event) {
        if (!((Boolean)APConfig.WORLD_CONFIG.enableVillagerStructures.get()).booleanValue()) {
            return;
        }
        Holder.Reference emptyProcessor = event.getServer().registryAccess().registryOrThrow(Registries.PROCESSOR_LIST).getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.parse((String)"minecraft:empty")));
        Registry templatePoolRegistry = event.getServer().registryAccess().registryOrThrow(Registries.TEMPLATE_POOL);
        for (String biome : new String[]{"desert", "snowy", "plains", "savanna", "taiga"}) {
            AdvancedPeripherals.debug("Register generating scientist_" + biome + " village house");
            VillageStructures.addPieceToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Holder<StructureProcessorList>)emptyProcessor, ResourceLocation.parse((String)("village/" + biome + "/houses")), "advancedperipherals:villages/scientist_" + biome, StructureTemplatePool.Projection.RIGID, (Integer)APConfig.WORLD_CONFIG.villagerStructureWeight.get());
        }
    }
}

