/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import appeng.api.stacks.GenericStack;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import de.srendi.advancedperipherals.common.addons.APAddon;
import de.srendi.advancedperipherals.common.addons.mekanism.Mekanism;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalFilter;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import net.minecraft.core.registries.BuiltInRegistries;

public abstract class GenericFilter<T> {
    private static final GenericFilter EMPTY = new GenericFilter(){

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean testAE(GenericStack genericStack) {
            return false;
        }

        @Override
        public boolean testRS(ResourceAmount resourceAmount) {
            return false;
        }

        public boolean test(Object toTest) {
            return false;
        }

        public GenericFilter copy() {
            return this;
        }
    };

    public static <T> GenericFilter<T> empty() {
        return EMPTY;
    }

    public static Pair<? extends GenericFilter<?>, String> parseGeneric(LuaTable<?, ?> rawFilter) throws LuaException {
        if (rawFilter.containsKey((Object)"type")) {
            String type;
            return switch (type = rawFilter.getString("type")) {
                case "item" -> ItemFilter.parse(rawFilter);
                case "fluid" -> FluidFilter.parse(rawFilter);
                case "chemical" -> {
                    if (!APAddon.MEKANISM.isLoaded()) {
                        throw new LuaException("cannot use chemical filter: Mekanism is required");
                    }
                    yield ChemicalFilter.parse(rawFilter);
                }
                default -> throw new LuaException("unexpected filter type " + type);
            };
        }
        if (!rawFilter.containsKey((Object)"name")) {
            throw new LuaException("Generic filter requires either field \"type\" or \"name\"");
        }
        String name = rawFilter.getString("name");
        if (ItemUtil.getRegistryEntry(name, BuiltInRegistries.ITEM) != null) {
            return ItemFilter.parse(rawFilter);
        }
        if (ItemUtil.getRegistryEntry(name, BuiltInRegistries.FLUID) != null) {
            return FluidFilter.parse(rawFilter);
        }
        if (APAddon.MEKANISM.isLoaded() && ItemUtil.getRegistryEntry(name, Mekanism.getChemicalRegistry()) != null) {
            return ChemicalFilter.parse(rawFilter);
        }
        return Pair.of(GenericFilter.empty(), "NO_VALID_FILTER_TYPE");
    }

    public abstract boolean isEmpty();

    public abstract boolean testAE(GenericStack var1);

    public abstract boolean testRS(ResourceAmount var1);

    public abstract boolean test(T var1);

    public abstract GenericFilter<T> copy();
}

