/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import appeng.api.stacks.GenericStack;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.APAddon;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSApi;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalUtil;
import de.srendi.advancedperipherals.common.util.inventory.GenericFilter;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class ChemicalFilter
extends GenericFilter<ChemicalStack> {
    public static final ChemicalFilter EMPTY = new ChemicalFilter();
    private Holder<Chemical> chemical = MekanismAPI.EMPTY_CHEMICAL.getAsHolder();
    private TagKey<Chemical> tag = null;
    private long amount = 1000L;
    private String fingerprint = "";
    public int fromSlot = -1;
    public int toSlot = -1;

    private ChemicalFilter() {
    }

    public static Pair<ChemicalFilter, String> parse(LuaTable<?, ?> item) throws LuaException {
        if (item.isEmpty()) {
            return Pair.of(EMPTY, null);
        }
        ChemicalFilter chemicalFilter = ChemicalFilter.createEmpty();
        if (item.containsKey((Object)"name")) {
            String name = item.getString("name");
            if (name.startsWith("#")) {
                chemicalFilter.tag = TagKey.create((net.minecraft.resources.ResourceKey)MekanismAPI.CHEMICAL_REGISTRY_NAME, (ResourceLocation)ResourceLocation.parse((String)name.substring(1)));
            } else {
                chemicalFilter.chemical = MekanismAPI.CHEMICAL_REGISTRY.getHolder(ResourceLocation.parse((String)name)).orElse(null);
                if (chemicalFilter.chemical == null) {
                    return Pair.of(null, "CHEMICAL_NOT_FOUND");
                }
            }
        }
        if (item.containsKey((Object)"fingerprint")) {
            chemicalFilter.fingerprint = item.getString("fingerprint");
        }
        if (item.containsKey((Object)"fromSlot")) {
            chemicalFilter.fromSlot = item.getInt("fromSlot");
        }
        if (item.containsKey((Object)"toSlot")) {
            chemicalFilter.toSlot = item.getInt("toSlot");
        }
        if (item.containsKey((Object)"amount")) {
            chemicalFilter.amount = item.getLong("amount");
        } else if (item.containsKey((Object)"count")) {
            chemicalFilter.amount = item.getLong("count");
        }
        AdvancedPeripherals.debug("Parsed item filter: " + String.valueOf(chemicalFilter));
        return Pair.of(chemicalFilter, null);
    }

    public static ChemicalFilter fromStack(ChemicalStack stack) {
        return ChemicalFilter.fromStackWithAmount(stack, stack.getAmount());
    }

    public static ChemicalFilter fromStackWithAmount(ChemicalStack stack, long amount) {
        ChemicalFilter filter = ChemicalFilter.createEmpty();
        filter.chemical = stack.getChemicalHolder();
        filter.amount = amount;
        return filter;
    }

    public static ChemicalFilter createEmpty() {
        return new ChemicalFilter();
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY || this.fingerprint.isEmpty() && this.chemical.is(MekanismAPI.EMPTY_CHEMICAL_NAME) && this.tag == null;
    }

    @Override
    public boolean testAE(GenericStack genericStack) {
        return false;
    }

    @Override
    public boolean testRS(ResourceAmount resourceAmount) {
        if (!APAddon.REFINEDSTORAGE_MEKANISM.isLoaded()) {
            return false;
        }
        ResourceKey resourceKey = resourceAmount.resource();
        if (resourceKey instanceof ChemicalResource) {
            ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
            return this.test(RSApi.resourceToChemicalStack(chemicalResource));
        }
        return false;
    }

    public ChemicalFilter copy() {
        ChemicalFilter newFilter = new ChemicalFilter();
        newFilter.chemical = this.chemical;
        newFilter.tag = this.tag;
        newFilter.amount = this.amount;
        newFilter.fingerprint = this.fingerprint;
        newFilter.fromSlot = this.fromSlot;
        newFilter.toSlot = this.toSlot;
        return newFilter;
    }

    public ChemicalFilter copyWithAmount(long amount) {
        ChemicalFilter newFilter = this.copy();
        newFilter.amount = amount;
        return newFilter;
    }

    public ChemicalStack toChemicalStack() {
        return new ChemicalStack(this.chemical, this.amount);
    }

    @Override
    public boolean test(ChemicalStack stack) {
        if (this.isEmpty()) {
            return true;
        }
        if (!this.fingerprint.isEmpty()) {
            String testFingerprint = ChemicalUtil.getFingerprint(stack);
            return this.fingerprint.equals(testFingerprint);
        }
        if (!this.chemical.is(MekanismAPI.EMPTY_CHEMICAL_NAME) && !stack.is(this.chemical)) {
            return false;
        }
        return this.tag == null || stack.is(this.tag);
    }

    public long getAmount() {
        return this.amount;
    }

    public Holder<Chemical> getChemical() {
        return this.chemical;
    }

    public int getFromSlot() {
        return this.fromSlot;
    }

    public int getToSlot() {
        return this.toSlot;
    }

    public String toString() {
        return "ChemicalFilter{item=" + this.chemical.getRegisteredName() + ", tag=" + String.valueOf(this.tag) + ", amount=" + this.amount + ", fingerprint='" + this.fingerprint + "', fromSlot=" + this.fromSlot + ", toSlot=" + this.toSlot + "}";
    }
}

