/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.blocks.base;

import de.srendi.advancedperipherals.common.blocks.base.IHarvestableBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class BaseBlock
extends Block
implements IHarvestableBlock {
    public static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.ORIENTATION;
    private final TagKey<Block> harvestTag;

    public BaseBlock() {
        this((TagKey<Block>)Tags.Blocks.NEEDS_WOOD_TOOL);
    }

    public BaseBlock(TagKey<Block> harvestTag) {
        this(BlockBehaviour.Properties.of().sound(SoundType.METAL).mapColor(DyeColor.GRAY).strength(1.0f, 5.0f).sound(SoundType.METAL).noOcclusion().requiresCorrectToolForDrops(), harvestTag);
    }

    public BaseBlock(BlockBehaviour.Properties properties, TagKey<Block> harvestTag) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(ORIENTATION, (Comparable)FrontAndTop.NORTH_UP));
        this.harvestTag = harvestTag;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public TagKey<Block> getHarvestTag() {
        return this.harvestTag;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{ORIENTATION});
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue(ORIENTATION, (Comparable)pRotation.rotation().rotate((FrontAndTop)pState.getValue(ORIENTATION)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.setValue(ORIENTATION, (Comparable)pMirror.rotation().rotate((FrontAndTop)pState.getValue(ORIENTATION)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction direction = pContext.getNearestLookingDirection().getOpposite();
        Direction direction1 = direction.getAxis() == Direction.Axis.Y ? pContext.getHorizontalDirection() : Direction.UP;
        return (BlockState)this.defaultBlockState().setValue(ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)direction, (Direction)direction1));
    }
}

