/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.refinedstorage;

import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewType;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.autocrafting.TimeoutableCancellationToken;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import dan200.computercraft.api.peripheral.IComputerAccess;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSApi;
import de.srendi.advancedperipherals.common.util.StatusConstants;
import de.srendi.advancedperipherals.common.util.inventory.BasicCraftJob;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.minecraft.world.level.Level;

public class RSCraftJob
extends BasicCraftJob {
    private final AutocraftingNetworkComponent autocraftingComponent;
    private final ResourceKey toCraft;
    private TaskStatus craftingTask;
    private Preview preview;
    private Future<Optional<Preview>> futureCalculationResult;
    private Optional<TaskId> futureTask = Optional.empty();

    public RSCraftJob(IComputerAccess computer, Level world, long amount, ResourceKey toCraft, AutocraftingNetworkComponent calculationResult) {
        super(computer, "rs", world, amount);
        this.autocraftingComponent = calculationResult;
        this.toCraft = toCraft;
    }

    @Override
    protected boolean isJobDone() {
        return this.craftingTask != null && this.craftingTask.percentageCompleted() >= 100.0;
    }

    @Override
    protected boolean isJobCanceled() {
        return this.craftingTask != null && this.craftingTask.percentageCompleted() < 100.0 && this.autocraftingComponent.getStatuses().stream().noneMatch(task -> task.info().id() == this.craftingTask.info().id());
    }

    @Override
    public Object getParsedRequestedItemImpl() {
        return RSApi.getObjectFromResourceKey(this.toCraft, this.amount, this.autocraftingComponent);
    }

    @Override
    public long getElapsedTimeImpl() {
        if (this.craftingTask == null) {
            return -1L;
        }
        return System.currentTimeMillis() - this.craftingTask.info().startTime();
    }

    @Override
    public long getTotalItemsImpl() {
        if (this.craftingTask == null) {
            return -1L;
        }
        return this.craftingTask.items().size();
    }

    @Override
    public long getItemProgressImpl() {
        return this.craftingTask == null ? 0L : this.craftingTask.items().stream().mapToLong(TaskStatus.Item::stored).sum();
    }

    @Override
    public Object getEmittedItemsImpl() {
        if (this.preview == null) {
            return Collections.emptyList();
        }
        return this.preview.items().stream().filter(item -> item.toCraft() > 0L).map(item -> RSApi.getObjectFromResourceKey(item.resource(), item.toCraft(), this.autocraftingComponent)).collect(Collectors.toList());
    }

    @Override
    public Object getUsedItemsImpl() {
        return Collections.emptyList();
    }

    @Override
    public Object getMissingItemsImpl() {
        if (this.preview == null) {
            return Collections.emptyList();
        }
        return this.preview.items().stream().filter(item -> item.missing() > 0L).map(item -> RSApi.getObjectFromResourceKey(item.resource(), item.missing(), this.autocraftingComponent)).collect(Collectors.toList());
    }

    @Override
    public boolean hasMultiplePathsImpl() {
        return false;
    }

    @Override
    public Object getFinalOutputImpl() {
        if (this.preview == null) {
            return Collections.emptyList();
        }
        return this.preview.outputsOfPatternWithCycle().stream().map(resource -> RSApi.getObjectFromResourceAmount(resource, this.autocraftingComponent)).collect(Collectors.toList());
    }

    public TaskStatus getCraftingTask() {
        return this.craftingTask;
    }

    @Override
    public boolean cancelImpl() {
        if (this.isJobDone() || this.isJobCanceled()) {
            return false;
        }
        this.autocraftingComponent.cancel(this.craftingTask.info().id());
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.craftingTask != null) {
            for (TaskStatus status : this.autocraftingComponent.getStatuses()) {
                if (!status.info().id().equals((Object)this.craftingTask.info().id())) continue;
                this.craftingTask = status;
                break;
            }
        }
        if (this.futureTask.isEmpty() || this.craftingTask != null) {
            return;
        }
        TaskId id = this.futureTask.get();
        for (TaskStatus status : this.autocraftingComponent.getStatuses()) {
            if (!status.info().id().equals((Object)id)) continue;
            this.craftingTask = status;
            this.setStartedCrafting();
            break;
        }
    }

    @Override
    protected void maybeCraft() {
        Preview preview;
        Optional<Preview> optionalPreview;
        if (this.startedCrafting || this.futureTask.isPresent() || this.futureCalculationResult == null || !this.futureCalculationResult.isDone()) {
            return;
        }
        try {
            optionalPreview = this.futureCalculationResult.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            AdvancedPeripherals.debug("Tried to get preview, but preview calculation is not done. Should be done.", ex);
            this.fireEvent(true, StatusConstants.UNKNOWN_ERROR);
            return;
        }
        if (optionalPreview.isEmpty()) {
            AdvancedPeripherals.debug("preview optional is empty.", org.apache.logging.log4j.Level.ERROR);
            this.fireEvent(true, StatusConstants.UNKNOWN_ERROR);
            return;
        }
        this.preview = preview = optionalPreview.get();
        PreviewType previewType = preview.type();
        if (previewType == PreviewType.MISSING_RESOURCES) {
            this.calculationNotSuccessful = true;
            this.fireEvent(true, StatusConstants.MISSING_ITEMS);
            return;
        }
        if (previewType != PreviewType.SUCCESS) {
            this.calculationNotSuccessful = true;
            this.fireEvent(true, previewType.toString());
            return;
        }
        this.futureTask = this.autocraftingComponent.startTask(this.toCraft, this.amount, Actor.EMPTY, false, (CancellationToken)new TimeoutableCancellationToken());
    }

    @Override
    protected void startCalculation() {
        if (this.startedCalculation) {
            return;
        }
        this.startedCalculation = true;
        if (this.autocraftingComponent.getPatternsByOutput(this.toCraft).isEmpty()) {
            this.fireEvent(true, StatusConstants.NOT_CRAFTABLE);
            return;
        }
        this.futureCalculationResult = this.autocraftingComponent.getPreview(this.toCraft, this.amount, (CancellationToken)new TimeoutableCancellationToken());
        this.fireEvent(false, StatusConstants.CALCULATION_STARTED);
    }

    @Override
    public void jobStateChanged() {
        if (this.craftingTask == null) {
            this.fireEvent(true, StatusConstants.UNKNOWN_ERROR);
            return;
        }
        if (this.isJobCanceled() && !this.isJobCanceled) {
            this.fireEvent(false, StatusConstants.JOB_CANCELED);
            this.setJobCanceled();
            return;
        }
        if (this.isJobDone() && !this.isJobDone) {
            this.fireEvent(true, StatusConstants.JOB_DONE);
            this.setJobDone();
        }
    }
}

