/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.refinedstorage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSApi;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalFilter;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalUtil;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemChemicalHandler;
import de.srendi.advancedperipherals.common.util.inventory.StorageProcessor;
import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import org.jetbrains.annotations.NotNull;

public class RSChemicalHandler
implements IStorageSystemChemicalHandler {
    @NotNull
    private final Network network;
    private final StorageNetworkComponent component;

    public RSChemicalHandler(@NotNull Network network) {
        this.network = network;
        this.component = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
    }

    @Override
    @NotNull
    public ChemicalStack insertChemical(ChemicalStack resource, @NotNull mekanism.api.Action action) {
        if (resource.isEmpty()) {
            return resource;
        }
        long amountInserted = this.component.insert((ResourceKey)ChemicalResource.ofChemicalStack((ChemicalStack)resource), resource.getAmount(), action.simulate() ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
        ChemicalStack remain = resource.copyWithAmount(resource.getAmount() - amountInserted);
        return remain;
    }

    @Override
    public long extractChemicals(ChemicalFilter filter, StorageProcessor.Large<ChemicalStack> processor, mekanism.api.Action action) {
        List<ChemicalResource> chemicals = RSApi.getChemicals(this.network, filter);
        if (chemicals.isEmpty()) {
            return 0L;
        }
        long needs = filter.getAmount();
        for (ChemicalResource chemical : chemicals) {
            long extracted;
            long amount = this.component.extract((ResourceKey)chemical, needs, Action.SIMULATE, Actor.EMPTY);
            if (amount == 0L || (extracted = processor.process(ChemicalUtil.toChemicalStack(chemical.chemical(), amount))) == 0L) continue;
            needs -= extracted;
            if (action.execute()) {
                this.component.extract((ResourceKey)chemical, extracted, Action.EXECUTE, Actor.EMPTY);
            }
            if (needs > 0L) continue;
            break;
        }
        return filter.getAmount() - needs;
    }
}

