/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.operations;

import com.google.common.math.IntMath;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SphereOperationContext;
import de.srendi.advancedperipherals.common.setup.DataComponents;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.neoforged.neoforge.common.ModConfigSpec;

public enum SphereOperation implements IPeripheralOperation<SphereOperationContext>
{
    SCAN_BLOCKS(2000, 8, 16, 0.17),
    SCAN_ENTITIES(2000, 8, 16, 0.17);

    private final int defaultCooldown;
    private final int defaultMaxFreeRadius;
    private final int defaultMaxCostRadius;
    private final double defaultExtraBlockCost;
    private ModConfigSpec.IntValue cooldown;
    private ModConfigSpec.IntValue maxFreeRadius;
    private ModConfigSpec.IntValue maxCostRadius;
    private ModConfigSpec.DoubleValue extraBlockCost;

    private SphereOperation(int defaultCooldown, int defaultMaxFreeRadius, int defaultMaxCostRadius, double defaultExtraBlockCost) {
        this.defaultCooldown = defaultCooldown;
        this.defaultMaxFreeRadius = defaultMaxFreeRadius;
        this.defaultMaxCostRadius = defaultMaxCostRadius;
        this.defaultExtraBlockCost = defaultExtraBlockCost;
    }

    @Override
    public void addToConfig(ModConfigSpec.Builder builder) {
        this.cooldown = builder.defineInRange(this.settingsName() + "Cooldown", this.defaultCooldown, 0, Integer.MAX_VALUE);
        this.maxFreeRadius = builder.defineInRange(this.settingsName() + "MaxFreeRadius", this.defaultMaxFreeRadius, 1, Integer.MAX_VALUE);
        this.maxCostRadius = builder.defineInRange(this.settingsName() + "MaxCostRadius", this.defaultMaxCostRadius, 1, Integer.MAX_VALUE);
        this.extraBlockCost = builder.defineInRange(this.settingsName() + "ExtraBlockCost", this.defaultExtraBlockCost, 0.1, Double.MAX_VALUE);
    }

    @Override
    public int getInitialCooldown() {
        return (Integer)this.cooldown.get();
    }

    @Override
    public int getCooldown(SphereOperationContext context) {
        return (Integer)this.cooldown.get();
    }

    @Override
    public int getCost(SphereOperationContext context) {
        if (context.getRadius() <= (Integer)this.maxFreeRadius.get()) {
            return 0;
        }
        int freeBlockCount = IntMath.pow((int)(2 * (Integer)this.maxFreeRadius.get() + 1), (int)3);
        int allBlockCount = IntMath.pow((int)(2 * context.getRadius() + 1), (int)3);
        return (int)Math.floor((double)(allBlockCount - freeBlockCount) * (Double)this.extraBlockCost.get());
    }

    public int getMaxFreeRadius() {
        return (Integer)this.maxFreeRadius.get();
    }

    public int getMaxCostRadius() {
        return (Integer)this.maxCostRadius.get();
    }

    @Override
    public Map<String, Object> computerDescription() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", this.settingsName());
        data.put("type", this.getClass().getName());
        data.put("cooldown", this.cooldown.get());
        data.put("maxFreeRadius", this.maxFreeRadius.get());
        data.put("maxCostRadius", this.maxCostRadius.get());
        data.put("extraBlockCost", this.extraBlockCost.get());
        return data;
    }

    public SphereOperationContext free() {
        return new SphereOperationContext(this.getMaxFreeRadius());
    }

    public SphereOperationContext cost() {
        return new SphereOperationContext(this.getMaxCostRadius());
    }

    @Override
    public DataComponentType<Long> dataComponentType() {
        return (DataComponentType)DataComponents.SPHERE_OPERATION.get();
    }
}

