/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AEApi;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemFluidHandler;
import de.srendi.advancedperipherals.common.util.inventory.StorageProcessor;
import java.util.List;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class MEFluidHandler
implements IStorageSystemFluidHandler {
    @NotNull
    private final MEStorage storageMonitor;
    @NotNull
    private final IActionSource actionSource;

    public MEFluidHandler(@NotNull MEStorage storageMonitor, @NotNull IActionSource actionSource) {
        this.storageMonitor = storageMonitor;
        this.actionSource = actionSource;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        AEFluidKey itemKey = AEFluidKey.of((Fluid)resource.getFluid());
        return (int)this.storageMonitor.insert((AEKey)itemKey, (long)resource.getAmount(), action.simulate() ? Actionable.SIMULATE : Actionable.MODULATE, this.actionSource);
    }

    @Override
    public int extractFluids(FluidFilter filter, StorageProcessor<FluidStack> processor, IFluidHandler.FluidAction action) {
        List<Pair<Long, AEFluidKey>> fluidKeys = AEApi.findAEFluidsFromFilter(this.storageMonitor, filter);
        if (fluidKeys.isEmpty()) {
            return 0;
        }
        int needs = filter.getAmount();
        for (Pair<Long, AEFluidKey> pair : fluidKeys) {
            int extracted;
            AEFluidKey fluidKey = pair.right();
            int amount = (int)this.storageMonitor.extract((AEKey)fluidKey, (long)needs, Actionable.SIMULATE, this.actionSource);
            if (amount == 0 || (extracted = processor.process(new FluidStack(fluidKey.getFluid(), amount))) == 0) continue;
            needs -= extracted;
            if (action.execute()) {
                this.storageMonitor.extract((AEKey)fluidKey, (long)extracted, Actionable.MODULATE, this.actionSource);
            }
            if (needs > 0) continue;
            break;
        }
        return filter.getAmount() - needs;
    }
}

