/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.AECapabilities;
import appeng.api.crafting.IPatternDetails;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.crafting.CraftingJobStatus;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.AEKeyFilter;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.blockentity.storage.DriveBlockEntity;
import appeng.core.definitions.AEItems;
import appeng.crafting.execution.CraftingCpuLogic;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.helpers.patternprovider.PatternContainer;
import appeng.items.storage.BasicStorageCell;
import appeng.me.cells.BasicCellHandler;
import appeng.me.cells.BasicCellInventory;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.parts.storagebus.StorageBusPart;
import com.google.common.collect.UnmodifiableIterator;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.APAddon;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AECraftJob;
import de.srendi.advancedperipherals.common.setup.BlockEntityTypes;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.StatusConstants;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalFilter;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.FluidUtil;
import de.srendi.advancedperipherals.common.util.inventory.GenericFilter;
import de.srendi.advancedperipherals.common.util.inventory.InventoryUtil;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import io.github.projectet.ae2things.item.DISKDrive;
import io.github.projectet.ae2things.storage.DISKCellHandler;
import io.github.projectet.ae2things.storage.DISKCellInventory;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import me.ramidzkh.mekae2.item.ChemicalStorageCell;
import mekanism.api.chemical.ChemicalStack;
import mekanism.common.tile.TileEntityChemicalTank;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AEApi {
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, (BlockEntityType)BlockEntityTypes.ME_BRIDGE.get(), (blockEntity, side) -> blockEntity);
    }

    @NotNull
    public static Pair<Long, AEItemKey> findAEStackFromStack(MEStorage monitor, @Nullable ICraftingService crafting, ItemStack item) {
        return AEApi.findAEStackFromFilter(monitor, crafting, ItemFilter.fromStack(item));
    }

    @NotNull
    public static Pair<Long, AEItemKey> findAEStackFromFilter(MEStorage monitor, @Nullable ICraftingService crafting, ItemFilter filter) {
        AEItemKey key;
        for (Object2LongMap.Entry temp : monitor.getAvailableStacks()) {
            Object object = temp.getKey();
            if (!(object instanceof AEItemKey) || !filter.test((key = (AEItemKey)object).toStack())) continue;
            return Pair.of(temp.getLongValue(), key);
        }
        if (crafting == null) {
            return Pair.of(0L, null);
        }
        for (Object2LongMap.Entry temp : crafting.getCraftables(param -> true)) {
            if (!(temp instanceof AEItemKey) || !filter.test((key = (AEItemKey)temp).toStack())) continue;
            return Pair.of(0L, key);
        }
        return Pair.of(0L, null);
    }

    @NotNull
    public static List<Pair<Long, AEItemKey>> findAEStacksFromFilter(MEStorage monitor, ItemFilter filter) {
        ArrayList<Pair<Long, AEItemKey>> items = new ArrayList<Pair<Long, AEItemKey>>();
        for (Object2LongMap.Entry temp : monitor.getAvailableStacks()) {
            AEItemKey key;
            Object object = temp.getKey();
            if (!(object instanceof AEItemKey) || !filter.test((key = (AEItemKey)object).toStack())) continue;
            items.add(Pair.of(temp.getLongValue(), key));
        }
        return items;
    }

    @NotNull
    public static Pair<Long, AEFluidKey> findAEFluidFromStack(MEStorage monitor, @Nullable ICraftingService crafting, FluidStack item) {
        return AEApi.findAEFluidFromFilter(monitor, crafting, FluidFilter.fromStack(item));
    }

    @NotNull
    public static Pair<Long, AEFluidKey> findAEFluidFromFilter(MEStorage monitor, @Nullable ICraftingService crafting, FluidFilter filter) {
        AEFluidKey key;
        for (Object2LongMap.Entry temp : monitor.getAvailableStacks()) {
            Object object = temp.getKey();
            if (!(object instanceof AEFluidKey) || !filter.test((key = (AEFluidKey)object).toStack(1))) continue;
            return Pair.of(temp.getLongValue(), key);
        }
        if (crafting == null) {
            return Pair.of(0L, null);
        }
        for (Object2LongMap.Entry temp : crafting.getCraftables(param -> true)) {
            if (!(temp instanceof AEFluidKey) || !filter.test((key = (AEFluidKey)temp).toStack(1))) continue;
            return Pair.of(0L, key);
        }
        return Pair.of(0L, null);
    }

    @NotNull
    public static List<Pair<Long, AEFluidKey>> findAEFluidsFromFilter(MEStorage monitor, FluidFilter filter) {
        ArrayList<Pair<Long, AEFluidKey>> fluids = new ArrayList<Pair<Long, AEFluidKey>>();
        for (Object2LongMap.Entry temp : monitor.getAvailableStacks()) {
            AEFluidKey key;
            Object object = temp.getKey();
            if (!(object instanceof AEFluidKey) || !filter.test((key = (AEFluidKey)object).toStack(1))) continue;
            fluids.add(Pair.of(temp.getLongValue(), key));
        }
        return fluids;
    }

    @NotNull
    public static Pair<Long, MekanismKey> findAEChemicalFromStack(MEStorage monitor, @Nullable ICraftingService crafting, ChemicalStack stack) {
        return AEApi.findAEChemicalFromFilter(monitor, crafting, ChemicalFilter.fromStack(stack));
    }

    @NotNull
    public static Pair<Long, MekanismKey> findAEChemicalFromFilter(MEStorage monitor, @Nullable ICraftingService crafting, ChemicalFilter filter) {
        MekanismKey key;
        for (Object2LongMap.Entry temp : monitor.getAvailableStacks()) {
            Object object = temp.getKey();
            if (!(object instanceof MekanismKey) || !filter.test((key = (MekanismKey)object).getStack())) continue;
            return Pair.of(temp.getLongValue(), key);
        }
        if (crafting == null) {
            return Pair.of(0L, null);
        }
        for (Object2LongMap.Entry temp : crafting.getCraftables(param -> true)) {
            if (!(temp instanceof MekanismKey) || !filter.test((key = (MekanismKey)temp).getStack())) continue;
            return Pair.of(0L, key);
        }
        return Pair.of(0L, null);
    }

    @NotNull
    public static List<Pair<Long, MekanismKey>> findAEChemicalsFromFilter(MEStorage monitor, ChemicalFilter filter) {
        ArrayList<Pair<Long, MekanismKey>> chemicals = new ArrayList<Pair<Long, MekanismKey>>();
        for (Object2LongMap.Entry temp : monitor.getAvailableStacks()) {
            MekanismKey key;
            Object object = temp.getKey();
            if (!(object instanceof MekanismKey) || !filter.test((key = (MekanismKey)object).getStack())) continue;
            chemicals.add(Pair.of(temp.getLongValue(), key));
        }
        return chemicals;
    }

    @NotNull
    public static Pair<Pair<EncodedPatternItem<?>, IPatternDetails>, String> findPatternFromFilters(IGrid grid, Level level, @Nullable GenericFilter<?> inputFilter, @Nullable GenericFilter<?> outputFilter) {
        for (Pair<EncodedPatternItem<?>, IPatternDetails> pattern : AEApi.getPatterns(grid, level)) {
            boolean outputMatch;
            boolean inputMatch;
            IPatternDetails patternDetails;
            block8: {
                patternDetails = pattern.getRight();
                if (patternDetails.getInputs().length == 0 || patternDetails.getOutputs().isEmpty()) continue;
                inputMatch = false;
                outputMatch = false;
                if (inputFilter != null) {
                    for (IPatternDetails.IInput input : patternDetails.getInputs()) {
                        for (GenericStack possibleInput : input.getPossibleInputs()) {
                            if (!inputFilter.testAE(possibleInput)) continue;
                            inputMatch = true;
                            break block8;
                        }
                    }
                } else {
                    inputMatch = true;
                }
            }
            if (outputFilter != null) {
                for (GenericStack output : patternDetails.getOutputs()) {
                    if (!outputFilter.testAE(output)) continue;
                    outputMatch = true;
                    break;
                }
            } else {
                outputMatch = true;
            }
            if (!inputMatch || !outputMatch) continue;
            return Pair.of(Pair.of(pattern.getLeft(), patternDetails), null);
        }
        return Pair.of(null, StatusConstants.NOT_FOUND.toString());
    }

    public static List<Object> listItems(MEStorage monitor, ICraftingService service, ItemFilter filter) {
        ArrayList<Object> items = new ArrayList<Object>();
        KeyCounter keyCounter = monitor.getAvailableStacks();
        for (Object2LongMap.Entry aeKey : keyCounter) {
            AEItemKey itemKey;
            Object object = aeKey.getKey();
            if (!(object instanceof AEItemKey) || !filter.test((itemKey = (AEItemKey)object).getReadOnlyStack())) continue;
            items.add(AEApi.parseAeStack(Pair.of(aeKey.getLongValue(), itemKey), service));
        }
        return items;
    }

    public static List<Object> listCraftableItems(MEStorage monitor, ICraftingService service, ItemFilter filter) {
        ArrayList<Object> items = new ArrayList<Object>();
        KeyCounter keyCounter = monitor.getAvailableStacks();
        Set craftables = service.getCraftables(AEKeyFilter.none());
        for (AEKey aeKey : craftables) {
            AEItemKey itemKey;
            if (!(aeKey instanceof AEItemKey) || !filter.test((itemKey = (AEItemKey)aeKey).toStack())) continue;
            items.add(AEApi.parseAeStack(Pair.of(keyCounter.get(aeKey), aeKey), service));
        }
        return items;
    }

    public static List<Object> listFluids(MEStorage monitor, ICraftingService service, FluidFilter filter) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object2LongMap.Entry aeKey : monitor.getAvailableStacks()) {
            AEFluidKey fluidKey;
            Object object = aeKey.getKey();
            if (!(object instanceof AEFluidKey) || !filter.test((fluidKey = (AEFluidKey)object).toStack(1))) continue;
            items.add(AEApi.parseAeStack(Pair.of(aeKey.getLongValue(), fluidKey), service));
        }
        return items;
    }

    public static List<Object> listChemicals(MEStorage monitor, ICraftingService service, ChemicalFilter filter) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object2LongMap.Entry aeKey : monitor.getAvailableStacks()) {
            MekanismKey mekanismKey;
            Object object;
            if (!APAddon.APP_MEKANISTICS.isLoaded() || !((object = aeKey.getKey()) instanceof MekanismKey) || !filter.test((mekanismKey = (MekanismKey)object).getStack())) continue;
            items.add(AEApi.parseAeStack(Pair.of(aeKey.getLongValue(), mekanismKey), service));
        }
        return items;
    }

    public static List<Object> listCraftableFluids(MEStorage monitor, ICraftingService service, FluidFilter filter) {
        ArrayList<Object> items = new ArrayList<Object>();
        KeyCounter keyCounter = monitor.getAvailableStacks();
        Set craftables = service.getCraftables(AEKeyFilter.none());
        for (AEKey aeKey : craftables) {
            AEFluidKey fluidKey;
            if (!(aeKey instanceof AEFluidKey) || !filter.test((fluidKey = (AEFluidKey)aeKey).toStack(1))) continue;
            items.add(AEApi.parseAeStack(Pair.of(keyCounter.get(aeKey), aeKey), service));
        }
        return items;
    }

    public static List<Object> listCraftableChemicals(MEStorage monitor, ICraftingService service, ChemicalFilter filter) {
        ArrayList<Object> items = new ArrayList<Object>();
        KeyCounter keyCounter = monitor.getAvailableStacks();
        Set craftables = service.getCraftables(AEKeyFilter.none());
        for (AEKey aeKey : craftables) {
            MekanismKey mekanismKey;
            if (!(aeKey instanceof MekanismKey) || !filter.test((mekanismKey = (MekanismKey)aeKey).getStack())) continue;
            items.add(AEApi.parseAeStack(Pair.of(keyCounter.get(aeKey), aeKey), service));
        }
        return items;
    }

    public static List<Pair<EncodedPatternItem<?>, IPatternDetails>> getPatterns(IGrid grid, Level level) {
        ArrayList patterns = new ArrayList();
        for (Class machineClass : grid.getMachineClasses()) {
            Class<? extends PatternContainer> containerClass = AEApi.tryCastMachineToContainer(machineClass);
            if (containerClass == null) continue;
            for (PatternContainer container : grid.getActiveMachines(containerClass)) {
                for (ItemStack patternItem : container.getTerminalPatternInventory()) {
                    EncodedPatternItem item;
                    IPatternDetails patternDetails;
                    Item item2 = patternItem.getItem();
                    if (!(item2 instanceof EncodedPatternItem) || (patternDetails = (item = (EncodedPatternItem)item2).decode(patternItem, level)) == null) continue;
                    patterns.add(Pair.of(item, patternDetails));
                }
            }
        }
        return patterns;
    }

    public static List<Object> listPatterns(IGrid grid, Level level) {
        return AEApi.getPatterns(grid, level).stream().map(AEApi::parsePattern).collect(Collectors.toList());
    }

    public static List<Object> listDrives(IGrid grid) {
        ArrayList<Object> drives = new ArrayList<Object>();
        for (IGridNode node : grid.getMachineNodes(DriveBlockEntity.class)) {
            DriveBlockEntity drive = (DriveBlockEntity)node.getService(IStorageProvider.class);
            if (drive == null || drive.getCellCount() != 10) continue;
            drives.add(AEApi.parseDrive(drive));
        }
        return drives;
    }

    private static Class<? extends PatternContainer> tryCastMachineToContainer(Class<?> machineClass) {
        if (PatternContainer.class.isAssignableFrom(machineClass)) {
            return machineClass.asSubclass(PatternContainer.class);
        }
        return null;
    }

    public static <T extends AEKey> Map<String, Object> parseAeStack(Pair<Long, T> stack, @Nullable ICraftingService service) {
        if (stack.getRight() == null) {
            return null;
        }
        T t = stack.getRight();
        if (t instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)t;
            return AEApi.parseItemStack(Pair.of(stack.getLeft(), itemKey), service);
        }
        t = stack.getRight();
        if (t instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)t;
            return AEApi.parseFluidStack(Pair.of(stack.getLeft(), fluidKey), service);
        }
        if (APAddon.APP_MEKANISTICS.isLoaded() && (t = stack.getRight()) instanceof MekanismKey) {
            MekanismKey gasKey = (MekanismKey)t;
            return AEApi.parseChemStack(Pair.of(stack.getLeft(), gasKey), service);
        }
        AdvancedPeripherals.debug("Could not create table from unknown stack " + String.valueOf(((AEKey)stack.getRight()).getClass()) + " - Report this to the maintainer of ap", org.apache.logging.log4j.Level.WARN);
        return null;
    }

    public static Map<String, Object> parseGenericStack(GenericStack stack) {
        if (stack.what() == null) {
            return null;
        }
        AEKey aEKey = stack.what();
        if (aEKey instanceof AEItemKey) {
            AEItemKey aeItemKey = (AEItemKey)aEKey;
            return AEApi.parseItemStack(Pair.of(stack.amount(), aeItemKey), null);
        }
        aEKey = stack.what();
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey aeFluidKey = (AEFluidKey)aEKey;
            return AEApi.parseFluidStack(Pair.of(stack.amount(), aeFluidKey), null);
        }
        AdvancedPeripherals.debug("Could not create table from unknown stack " + String.valueOf(stack.getClass()) + " - Report this to the maintainer of ap", org.apache.logging.log4j.Level.WARN);
        return null;
    }

    public static List<Object> parseKeyCounter(KeyCounter counter) {
        ArrayList<Object> parsedKeys = new ArrayList<Object>();
        for (AEKey key : counter.keySet()) {
            parsedKeys.add(AEApi.parseGenericStack(new GenericStack(key, counter.get(key))));
        }
        return parsedKeys;
    }

    public static Map<Object, Object> parseDrive(DriveBlockEntity drive) {
        long totalBytes = 0L;
        long usedBytes = 0L;
        ArrayList<Map<Object, Object>> driveCells = new ArrayList<Map<Object, Object>>();
        for (ItemStack item : drive.getInternalInventory()) {
            Item item2 = item.getItem();
            if (!(item2 instanceof BasicStorageCell)) continue;
            BasicStorageCell cell = (BasicStorageCell)item2;
            BasicCellInventory cellInventory = BasicCellHandler.INSTANCE.getCellInventory(item, null);
            totalBytes += cellInventory.getTotalBytes();
            usedBytes += cellInventory.getUsedBytes();
            driveCells.add(AEApi.parseCell((IBasicCellItem)cell, item));
        }
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put("usedBytes", usedBytes);
        properties.put("totalBytes", totalBytes);
        properties.put("cells", driveCells);
        properties.put("priority", drive.getPriority());
        properties.put("menuIcon", LuaConverter.itemToObject(drive.getMainMenuIcon().getItem()));
        properties.put("position", LuaConverter.posToObject(drive.getBlockPos()));
        properties.put("name", drive.hasCustomName() ? drive.getCustomName().getString() : drive.getDisplayName().getString());
        return properties;
    }

    public static Map<Object, Object> parseCell(IBasicCellItem cell, ItemStack cellItem) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        BasicCellInventory cellInventory = BasicCellHandler.INSTANCE.getCellInventory(cellItem, null);
        properties.put("item", LuaConverter.itemToObject(cellItem.getItem()));
        properties.put("type", cell.getKeyType().toString());
        properties.put("bytes", cell.getBytes(cellItem));
        properties.put("bytesPerType", cell.getBytesPerType(cellItem));
        properties.put("usedBytes", cellInventory.getUsedBytes());
        properties.put("totalTypes", cell.getTotalTypes(cellItem));
        properties.put("fuzzyMode", cell.getFuzzyMode(cellItem).toString());
        return properties;
    }

    private static Map<String, Object> parseDISKDrive(DISKDrive drive, ItemStack stack) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        DISKCellInventory cellInventory = DISKCellHandler.INSTANCE.getCellInventory(stack, null);
        if (cellInventory == null) {
            return null;
        }
        properties.put("item", LuaConverter.itemToObject(stack.getItem()));
        properties.put("type", drive.getKeyType().toString());
        properties.put("bytes", drive.getBytes(stack));
        properties.put("bytesPerType", 0);
        properties.put("usedBytes", cellInventory.getNbtItemCount());
        properties.put("totalTypes", 0);
        properties.put("fuzzyMode", drive.getFuzzyMode(stack).toString());
        return properties;
    }

    private static Map<String, Object> parseItemStack(Pair<Long, AEItemKey> stack, @Nullable ICraftingService craftingService) {
        Map<String, Object> properties = LuaConverter.itemStackToObject(stack.getRight().getReadOnlyStack());
        properties.put("count", stack.getLeft());
        properties.put("isCraftable", craftingService != null && craftingService.isCraftable((AEKey)stack.getRight()));
        return properties;
    }

    private static Map<String, Object> parseFluidStack(Pair<Long, AEFluidKey> stack, @Nullable ICraftingService craftingService) {
        Map<String, Object> properties = LuaConverter.fluidStackToObject(stack.getRight().toStack(1));
        properties.put("count", stack.getLeft());
        properties.put("isCraftable", craftingService != null && craftingService.isCraftable((AEKey)stack.getRight()));
        return properties;
    }

    private static Map<String, Object> parseChemStack(Pair<Long, MekanismKey> stack, @Nullable ICraftingService craftingService) {
        Map<String, Object> properties = LuaConverter.chemicalStackToObject(stack.getRight().withAmount(stack.getLeft().longValue()));
        properties.put("isCraftable", craftingService != null && craftingService.isCraftable((AEKey)stack.getRight()));
        return properties;
    }

    public static Map<String, Object> parsePattern(Pair<EncodedPatternItem<?>, IPatternDetails> pattern) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        IPatternDetails patternDetails = pattern.getRight();
        String patternType = AEApi.getPatternType(pattern.getLeft());
        properties.put("inputs", Arrays.stream(patternDetails.getInputs()).map(AEApi::parsePatternInput).collect(Collectors.toList()));
        properties.put("outputs", patternDetails.getOutputs().stream().map(AEApi::parseGenericStack).collect(Collectors.toList()));
        properties.put("primaryOutput", AEApi.parseGenericStack(patternDetails.getPrimaryOutput()));
        properties.put("patternType", patternType);
        return properties;
    }

    private static String getPatternType(EncodedPatternItem<?> patternItem) {
        if (patternItem.equals((Object)AEItems.CRAFTING_PATTERN.get())) {
            return "crafting";
        }
        if (patternItem.equals((Object)AEItems.PROCESSING_PATTERN.get())) {
            return "processing";
        }
        if (patternItem.equals((Object)AEItems.SMITHING_TABLE_PATTERN.get())) {
            return "smithing";
        }
        if (patternItem.equals((Object)AEItems.STONECUTTING_PATTERN.get())) {
            return "stonecutting";
        }
        return "unknown";
    }

    public static Map<String, Object> parsePatternInput(IPatternDetails.IInput patternInput) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        GenericStack primaryInput = patternInput.getPossibleInputs()[0];
        properties.put("primaryInput", AEApi.parseGenericStack(primaryInput));
        properties.put("possibleInputs", Arrays.stream(Arrays.copyOfRange(patternInput.getPossibleInputs(), 1, patternInput.getPossibleInputs().length)).map(AEApi::parseGenericStack));
        properties.put("multiplier", patternInput.getMultiplier());
        AEKey remainingKey = patternInput.getRemainingKey(patternInput.getPossibleInputs()[0].what());
        Map<String, Object> remainingKeyProperties = remainingKey == null ? null : AEApi.parseGenericStack(new GenericStack(remainingKey, 1L));
        properties.put("remaining", remainingKeyProperties);
        return properties;
    }

    public static Map<String, Object> parseCraftingCPU(ICraftingCPU cpu, boolean recursive) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        long storage = cpu.getAvailableStorage();
        int coProcessors = cpu.getCoProcessors();
        boolean isBusy = cpu.isBusy();
        properties.put("storage", storage);
        properties.put("coProcessors", coProcessors);
        properties.put("isBusy", isBusy);
        if (!recursive) {
            properties.put("craftingJob", cpu.getJobStatus() != null ? AEApi.parseCraftingJob(cpu.getJobStatus(), null, null) : null);
        }
        properties.put("name", cpu.getName() != null ? cpu.getName().getString() : "Unnamed");
        properties.put("selectionMode", cpu.getSelectionMode().toString());
        return properties;
    }

    public static Object parseCraftingJob(CraftingJobStatus status, @Nullable AECraftJob craftJob, @Nullable ICraftingCPU cpu) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("bridge_id", craftJob == null ? -1L : craftJob.getId());
        properties.put("quantity", status.crafting().amount());
        properties.put("resource", AEApi.parseGenericStack(status.crafting()));
        if (cpu != null) {
            CraftingCpuLogic craftingCpuLogic = ((CraftingCPUCluster)cpu).craftingLogic;
            long pending = craftingCpuLogic.getPendingOutputs(status.crafting().what());
            long active = craftingCpuLogic.getWaitingFor(status.crafting().what());
            long crafted = status.crafting().amount() - (pending + active);
            properties.put("completion", (double)crafted / (double)status.crafting().amount());
            properties.put("crafted", crafted);
            properties.put("id", craftingCpuLogic.getLastLink().getCraftingID().toString());
            properties.put("cpu", AEApi.parseCraftingCPU(cpu, true));
        }
        return properties;
    }

    public static MEStorage getMonitor(IGridNode node) {
        return ((IStorageService)node.getGrid().getService(IStorageService.class)).getInventory();
    }

    public static boolean isCrafting(ICraftingService grid, GenericFilter<?> filter, @Nullable ICraftingCPU craftingCPU) {
        if (craftingCPU == null) {
            for (ICraftingCPU cpu : grid.getCpus()) {
                CraftingJobStatus jobStatus;
                if (!cpu.isBusy() || (jobStatus = cpu.getJobStatus()) == null || !filter.testAE(jobStatus.crafting())) continue;
                return true;
            }
        } else if (craftingCPU.isBusy()) {
            CraftingJobStatus jobStatus = craftingCPU.getJobStatus();
            if (jobStatus == null) {
                return false;
            }
            return filter.testAE(jobStatus.crafting());
        }
        return false;
    }

    public static long getTotalExternalItemStorage(IGridNode node) {
        long total = 0L;
        for (IGridNode iGridNode : node.getGrid().getMachineNodes(StorageBusPart.class)) {
            StorageBusPart bus = (StorageBusPart)iGridNode.getService(IStorageProvider.class);
            BlockPos connectedInventoryPos = bus.getHost().getBlockEntity().getBlockPos().relative(bus.getSide());
            IItemHandler itemHandler = InventoryUtil.extractHandler(null, bus.getLevel(), connectedInventoryPos, bus.getSide());
            if (itemHandler == null) continue;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                total += stack.isEmpty() ? (long)itemHandler.getSlotLimit(i) : (long)stack.getMaxStackSize();
            }
        }
        return total;
    }

    public static long getTotalExternalFluidStorage(IGridNode node) {
        long total = 0L;
        for (IGridNode iGridNode : node.getGrid().getMachineNodes(StorageBusPart.class)) {
            StorageBusPart bus = (StorageBusPart)iGridNode.getService(IStorageProvider.class);
            BlockPos connectedInventoryPos = bus.getHost().getBlockEntity().getBlockPos().relative(bus.getSide());
            IFluidHandler fluidHandler = FluidUtil.extractHandler(null, bus.getLevel(), connectedInventoryPos, bus.getSide());
            if (fluidHandler == null) continue;
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                total += (long)fluidHandler.getTankCapacity(i);
            }
        }
        return total;
    }

    public static long getTotalExternalChemicalStorage(IGridNode node) {
        long total = 0L;
        if (!APAddon.APP_MEKANISTICS.isLoaded()) {
            return 0L;
        }
        for (IGridNode iGridNode : node.getGrid().getMachineNodes(StorageBusPart.class)) {
            BlockPos connectedInventoryPos;
            StorageBusPart bus = (StorageBusPart)iGridNode.getService(IStorageProvider.class);
            Level level = bus.getLevel();
            BlockEntity connectedInventoryEntity = level.getBlockEntity(connectedInventoryPos = bus.getHost().getBlockEntity().getBlockPos().relative(bus.getSide()));
            if (connectedInventoryEntity == null || !(connectedInventoryEntity instanceof TileEntityChemicalTank)) continue;
            TileEntityChemicalTank tank = (TileEntityChemicalTank)connectedInventoryEntity;
            total += tank.getChemicalTank().getCapacity();
        }
        return total;
    }

    public static long getUsedExternalItemStorage(IGridNode node) {
        long used = 0L;
        for (IGridNode iGridNode : node.getGrid().getMachineNodes(StorageBusPart.class)) {
            StorageBusPart bus = (StorageBusPart)iGridNode.getService(IStorageProvider.class);
            KeyCounter keyCounter = bus.getInternalHandler().getAvailableStacks();
            for (Object2LongMap.Entry aeKey : keyCounter) {
                if (!(aeKey.getKey() instanceof AEItemKey)) continue;
                used += aeKey.getLongValue();
            }
        }
        return used;
    }

    public static long getUsedExternalFluidStorage(IGridNode node) {
        long used = 0L;
        for (IGridNode iGridNode : node.getGrid().getMachineNodes(StorageBusPart.class)) {
            StorageBusPart bus = (StorageBusPart)iGridNode.getService(IStorageProvider.class);
            KeyCounter keyCounter = bus.getInternalHandler().getAvailableStacks();
            for (Object2LongMap.Entry aeKey : keyCounter) {
                if (!(aeKey.getKey() instanceof AEFluidKey)) continue;
                used += aeKey.getLongValue();
            }
        }
        return used;
    }

    public static long getUsedExternalChemicalStorage(IGridNode node) {
        long used = 0L;
        if (!APAddon.APP_MEKANISTICS.isLoaded()) {
            return 0L;
        }
        for (IGridNode iGridNode : node.getGrid().getMachineNodes(StorageBusPart.class)) {
            StorageBusPart bus = (StorageBusPart)iGridNode.getService(IStorageProvider.class);
            KeyCounter keyCounter = bus.getInternalHandler().getAvailableStacks();
            for (Object2LongMap.Entry aeKey : keyCounter) {
                if (!(aeKey.getKey() instanceof MekanismKey)) continue;
                used += aeKey.getLongValue();
            }
        }
        return used;
    }

    public static long getTotalItemStorage(IGridNode node) {
        long total = 0L;
        for (IGridNode iGridNode : node.getGrid().getNodes()) {
            IGridNodeService iGridNodeService = iGridNode.getService(IStorageProvider.class);
            if (!(iGridNodeService instanceof DriveBlockEntity)) continue;
            DriveBlockEntity entity = (DriveBlockEntity)iGridNodeService;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                DISKDrive disk;
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                Item item = stack.getItem();
                if (item instanceof IBasicCellItem) {
                    IBasicCellItem cell = (IBasicCellItem)item;
                    if (!cell.getKeyType().getClass().isAssignableFrom(AEKeyType.items().getClass())) continue;
                    total += (long)cell.getBytes(null);
                    continue;
                }
                if (!APAddon.AE2_THINGS.isLoaded() || !((item = stack.getItem()) instanceof DISKDrive) || !(disk = (DISKDrive)item).getKeyType().toString().equals("ae2:i")) continue;
                total += (long)disk.getBytes(null);
            }
        }
        return total;
    }

    public static long getTotalFluidStorage(IGridNode node) {
        long total = 0L;
        for (IGridNode iGridNode : node.getGrid().getNodes()) {
            IGridNodeService iGridNodeService = iGridNode.getService(IStorageProvider.class);
            if (!(iGridNodeService instanceof DriveBlockEntity)) continue;
            DriveBlockEntity entity = (DriveBlockEntity)iGridNodeService;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                IBasicCellItem cell;
                Item item;
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof IBasicCellItem) || !(cell = (IBasicCellItem)item).getKeyType().getClass().isAssignableFrom(AEKeyType.fluids().getClass())) continue;
                total += (long)cell.getBytes(null);
            }
        }
        return total;
    }

    public static long getTotalChemicalStorage(IGridNode node) {
        long total = 0L;
        if (!APAddon.APP_MEKANISTICS.isLoaded()) {
            return 0L;
        }
        for (IGridNode iGridNode : node.getGrid().getMachineNodes(DriveBlockEntity.class)) {
            DriveBlockEntity entity = (DriveBlockEntity)iGridNode.getService(IStorageProvider.class);
            if (entity == null) continue;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                ChemicalStorageCell cell;
                Item item;
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof ChemicalStorageCell) || !((cell = (ChemicalStorageCell)item).getKeyType() instanceof MekanismKeyType)) continue;
                total += (long)cell.getBytes(null);
            }
        }
        return total;
    }

    public static long getUsedItemStorage(IGridNode node) {
        long used = 0L;
        for (IGridNode iGridNode : node.getGrid().getNodes()) {
            IGridNodeService iGridNodeService = iGridNode.getService(IStorageProvider.class);
            if (!(iGridNodeService instanceof DriveBlockEntity)) continue;
            DriveBlockEntity entity = (DriveBlockEntity)iGridNodeService;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                DISKCellInventory diskCellInventory;
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                Item item = stack.getItem();
                if (item instanceof IBasicCellItem) {
                    IBasicCellItem cell = (IBasicCellItem)item;
                    if (!cell.getKeyType().getClass().isAssignableFrom(AEKeyType.items().getClass())) continue;
                    BasicCellInventory cellInventory = BasicCellHandler.INSTANCE.getCellInventory(stack, null);
                    used += cellInventory.getUsedBytes();
                    continue;
                }
                if (!APAddon.AE2_THINGS.isLoaded() || !(stack.getItem() instanceof DISKDrive) || (diskCellInventory = DISKCellHandler.INSTANCE.getCellInventory(stack, null)) == null) continue;
                used += diskCellInventory.getNbtItemCount();
            }
        }
        return used;
    }

    public static long getUsedFluidStorage(IGridNode node) {
        long used = 0L;
        for (IGridNode iGridNode : node.getGrid().getNodes()) {
            IGridNodeService iGridNodeService = iGridNode.getService(IStorageProvider.class);
            if (!(iGridNodeService instanceof DriveBlockEntity)) continue;
            DriveBlockEntity entity = (DriveBlockEntity)iGridNodeService;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                IBasicCellItem cell;
                ItemStack stack = inventory.getStackInSlot(i);
                Item item = stack.getItem();
                if (!(item instanceof IBasicCellItem) || !(cell = (IBasicCellItem)item).getKeyType().getClass().isAssignableFrom(AEKeyType.fluids().getClass())) continue;
                BasicCellInventory cellInventory = BasicCellHandler.INSTANCE.getCellInventory(stack, null);
                used += cellInventory.getUsedBytes();
            }
        }
        return used;
    }

    public static long getUsedChemicalStorage(IGridNode node) {
        long used = 0L;
        if (!APAddon.APP_MEKANISTICS.isLoaded()) {
            return 0L;
        }
        for (IGridNode iGridNode : node.getGrid().getMachineNodes(DriveBlockEntity.class)) {
            DriveBlockEntity entity = (DriveBlockEntity)iGridNode.getService(IStorageProvider.class);
            if (entity == null) continue;
            InternalInventory inventory = entity.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (!(stack.getItem() instanceof ChemicalStorageCell)) continue;
                BasicCellInventory cellInventory = BasicCellHandler.INSTANCE.getCellInventory(stack, null);
                used += cellInventory.getUsedBytes();
            }
        }
        return used;
    }

    public static long getAvailableItemStorage(IGridNode node) {
        return AEApi.getTotalItemStorage(node) - AEApi.getUsedItemStorage(node);
    }

    public static long getAvailableFluidStorage(IGridNode node) {
        return AEApi.getTotalFluidStorage(node) - AEApi.getUsedFluidStorage(node);
    }

    public static long getAvailableChemicalStorage(IGridNode node) {
        return AEApi.getTotalChemicalStorage(node) - AEApi.getUsedChemicalStorage(node);
    }

    public static long getAvailableExternalItemStorage(IGridNode node) {
        return AEApi.getTotalExternalItemStorage(node) - AEApi.getUsedExternalItemStorage(node);
    }

    public static long getAvailableExternalFluidStorage(IGridNode node) {
        return AEApi.getTotalExternalFluidStorage(node) - AEApi.getUsedExternalFluidStorage(node);
    }

    public static long getAvailableExternalChemicalStorage(IGridNode node) {
        return AEApi.getTotalExternalChemicalStorage(node) - AEApi.getUsedExternalChemicalStorage(node);
    }

    public static ICraftingCPU getCraftingCPU(IGridNode node, String cpuName) {
        if (cpuName.isEmpty()) {
            return null;
        }
        ICraftingService grid = (ICraftingService)node.getGrid().getService(ICraftingService.class);
        if (grid == null) {
            return null;
        }
        UnmodifiableIterator iterator = grid.getCpus().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        while (iterator.hasNext()) {
            ICraftingCPU cpu = (ICraftingCPU)iterator.next();
            if (cpu.getName() == null || !cpu.getName().getString().equals(cpuName)) continue;
            return cpu;
        }
        return null;
    }

    public static List<Object> listCells(IGridNode node) {
        ArrayList<Object> items = new ArrayList<Object>();
        Iterator iterator = node.getGrid().getNodes().iterator();
        if (!iterator.hasNext()) {
            return items;
        }
        while (iterator.hasNext()) {
            IStorageProvider entity = (IStorageProvider)((IGridNode)iterator.next()).getService(IStorageProvider.class);
            if (!(entity instanceof DriveBlockEntity)) continue;
            DriveBlockEntity drive = (DriveBlockEntity)entity;
            InternalInventory inventory = drive.getInternalInventory();
            for (int i = 0; i < inventory.size(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                Item item = stack.getItem();
                if (item instanceof IBasicCellItem) {
                    IBasicCellItem cell = (IBasicCellItem)item;
                    items.add(AEApi.parseCell(cell, stack));
                    continue;
                }
                if (!APAddon.AE2_THINGS.isLoaded() || !((item = stack.getItem()) instanceof DISKDrive)) continue;
                DISKDrive disk = (DISKDrive)item;
                items.add(AEApi.parseDISKDrive(disk, stack));
            }
        }
        return items;
    }
}

