/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.util.DataComponentUtil;
import de.srendi.advancedperipherals.common.setup.Blocks;
import de.srendi.advancedperipherals.common.setup.Registration;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;

public class APCreativeTab {
    public static void populateCreativeTabBuilder(CreativeModeTab.Builder builder) {
        builder.displayItems((set, out) -> {
            Registration.ITEMS.getEntries().stream().map(DeferredHolder::get).forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
            APCreativeTab.addTurtle(out, (TurtleItem)ModRegistry.Items.TURTLE_NORMAL.get(), set.holders());
            APCreativeTab.addTurtle(out, (TurtleItem)ModRegistry.Items.TURTLE_ADVANCED.get(), set.holders());
            APCreativeTab.addPocket(out, (PocketComputerItem)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get(), set.holders());
            APCreativeTab.addPocket(out, (PocketComputerItem)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get(), set.holders());
        });
        builder.icon(() -> new ItemStack((ItemLike)Blocks.CHAT_BOX.get()));
        builder.title((Component)Component.translatable((String)"advancedperipherals.name"));
    }

    private static boolean isOurUpgrade(Holder.Reference<? extends UpgradeBase> upgrade) {
        String namespace = upgrade.key().location().getNamespace();
        return namespace.equals("advancedperipherals");
    }

    private static void addTurtle(CreativeModeTab.Output out, TurtleItem turtle, HolderLookup.Provider registries) {
        out.accept(new ItemStack((ItemLike)turtle));
        Stream<ItemStack> filteredItemStacks = registries.lookupOrThrow(ITurtleUpgrade.REGISTRY).listElements().filter(APCreativeTab::isOurUpgrade).map(x -> DataComponentUtil.createStack((ItemLike)turtle, (DataComponentType)((DataComponentType)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get()), (Object)UpgradeData.ofDefault((Holder.Reference)x)));
        Objects.requireNonNull(out);
        filteredItemStacks.forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
    }

    private static void addPocket(CreativeModeTab.Output out, PocketComputerItem pocket, HolderLookup.Provider registries) {
        out.accept(new ItemStack((ItemLike)pocket));
        Stream<ItemStack> filteredItemStacks = registries.lookupOrThrow(IPocketUpgrade.REGISTRY).listElements().filter(APCreativeTab::isOurUpgrade).map(x -> DataComponentUtil.createStack((ItemLike)pocket, (DataComponentType)((DataComponentType)ModRegistry.DataComponents.POCKET_UPGRADE.get()), (Object)UpgradeData.ofDefault((Holder.Reference)x)));
        Objects.requireNonNull(out);
        filteredItemStacks.forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
    }
}

