/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.xmod.rei;

import appeng.integration.modules.itemlists.CompatLayerHelper;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipe;
import net.pedroksl.advanced_ae.xmod.rei.recipes.REIReactionChamberCategory;
import net.pedroksl.advanced_ae.xmod.rei.recipes.REIReactionChamberDisplay;
import net.pedroksl.ae2addonlib.recipes.IngredientStack;

@REIPluginClient
public class REIPlugin
implements REIClientPlugin {
    public static final ResourceLocation TEXTURE = AdvancedAE.makeId("textures/guis/emi.png");

    public String getPluginProviderName() {
        return "Advanced AE";
    }

    public void registerDisplays(DisplayRegistry registry) {
        if (CompatLayerHelper.IS_LOADED) {
            return;
        }
        registry.registerRecipeFiller(ReactionChamberRecipe.class, ReactionChamberRecipe.TYPE, REIReactionChamberDisplay::new);
        REIPlugin.addDescription(registry, AAEItems.SHATTERED_SINGULARITY, new Component[]{AAEText.ShatteredSingularityDescription.text()});
    }

    public void registerCategories(CategoryRegistry registry) {
        if (CompatLayerHelper.IS_LOADED) {
            return;
        }
        registry.add((DisplayCategory)new REIReactionChamberCategory());
        registry.addWorkstations(REIReactionChamberDisplay.ID, new EntryStack[]{EntryStacks.of(AAEBlocks.REACTION_CHAMBER)});
    }

    private static void addDescription(DisplayRegistry registry, ItemLike stack, Component ... desc) {
        DefaultInformationDisplay info = DefaultInformationDisplay.createFromEntry((EntryStack)EntryStacks.of((ItemLike)stack), (Component)stack.asItem().getDescription());
        info.lines(desc);
        registry.add((Display)info);
    }

    public static EntryIngredient stackOf(IngredientStack.Item stack) {
        if (!stack.isEmpty()) {
            ItemStack[] stacks = ((Ingredient)stack.getIngredient()).getItems();
            EntryIngredient.Builder result = EntryIngredient.builder((int)stacks.length);
            for (ItemStack ing : stacks) {
                if (ing.isEmpty()) continue;
                result.add(EntryStacks.of((ItemStack)ing.copyWithCount(stack.getAmount())));
            }
            return result.build();
        }
        return EntryIngredient.empty();
    }

    public static EntryIngredient stackOf(IngredientStack.Fluid stack, float tankSize) {
        if (!stack.isEmpty()) {
            FluidStack[] stacks = ((FluidIngredient)stack.getIngredient()).getStacks();
            EntryIngredient.Builder result = EntryIngredient.builder((int)stacks.length);
            for (FluidStack ing : stacks) {
                if (ing.isEmpty()) continue;
                EntryStack f = EntryStacks.of((Fluid)ing.getFluid(), (long)stack.getAmount());
                ClientEntryStacks.setFluidRenderRatio((EntryStack)f, (float)((float)stack.getAmount() / tankSize));
                result.add(f);
            }
            return result.build();
        }
        return EntryIngredient.empty();
    }
}

