/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.datagen;

import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import appeng.datagen.providers.tags.ConventionTags;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipeBuilder;
import com.glodblock.github.appflux.common.AFSingletons;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.recipe.CircuitCutterRecipeBuilder;
import com.glodblock.github.extendedae.recipe.CrystalAssemblerRecipeBuilder;
import gripe._90.megacells.definition.MEGAItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import mekanism.api.datagen.recipe.builder.ItemStackToItemStackRecipeBuilder;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.AndCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.datagen.AAEConventionTags;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipeBuilder;
import net.pedroksl.advanced_ae.xmod.Addons;
import org.jetbrains.annotations.NotNull;

public class AAERecipeProvider
extends RecipeProvider {
    public AAERecipeProvider(PackOutput p, CompletableFuture<HolderLookup.Provider> provider) {
        super(p, provider);
    }

    protected void buildRecipes(@NotNull RecipeOutput c) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEBlocks.ADV_PATTERN_PROVIDER).pattern("PR").pattern("EL").define(Character.valueOf('P'), (ItemLike)EAESingletons.EX_PATTERN_PROVIDER).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('E'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('L'), (ItemLike)AEItems.LOGIC_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEBlocks.PATTERN_PROVIDER)).save(Addons.EXTENDEDAE.conditionalRecipe(c), AdvancedAE.makeId("eaeadvpatpro"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEBlocks.SMALL_ADV_PATTERN_PROVIDER).pattern("PR").pattern("EL").define(Character.valueOf('P'), (ItemLike)AEBlocks.PATTERN_PROVIDER).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('E'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('L'), (ItemLike)AEItems.LOGIC_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEBlocks.PATTERN_PROVIDER)).save(c, AdvancedAE.makeId("smalladvpatpro"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AAEBlocks.ADV_PATTERN_PROVIDER).requires(AAEItems.ADV_PATTERN_PROVIDER).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEBlocks.PATTERN_PROVIDER)).save(c, AdvancedAE.makeId("advpatpro2"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AAEItems.ADV_PATTERN_PROVIDER).requires(AAEBlocks.ADV_PATTERN_PROVIDER).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEBlocks.PATTERN_PROVIDER)).save(c, AdvancedAE.makeId("advpatpropart"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AAEBlocks.SMALL_ADV_PATTERN_PROVIDER).requires(AAEItems.SMALL_ADV_PATTERN_PROVIDER).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEBlocks.PATTERN_PROVIDER)).save(c, AdvancedAE.makeId("smalladvpatpro2"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AAEItems.SMALL_ADV_PATTERN_PROVIDER).requires(AAEBlocks.SMALL_ADV_PATTERN_PROVIDER).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEBlocks.PATTERN_PROVIDER)).save(c, AdvancedAE.makeId("smalladvpatpropart"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEBlocks.REACTION_CHAMBER).pattern("EME").pattern("FVF").pattern("GBG").define(Character.valueOf('E'), (ItemLike)AEItems.FLUIX_DUST).define(Character.valueOf('M'), (ItemLike)AEBlocks.CONDENSER).define(Character.valueOf('F'), (ItemLike)AEItems.FLUIX_DUST).define(Character.valueOf('G'), (ItemLike)Items.GLOWSTONE_DUST).define(Character.valueOf('V'), (ItemLike)AEBlocks.VIBRATION_CHAMBER).define(Character.valueOf('B'), (ItemLike)Items.BUCKET).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEBlocks.VIBRATION_CHAMBER)).save(c, AdvancedAE.makeId("reactionchamber"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEBlocks.QUANTUM_CRAFTER).pattern("SAS").pattern("KUK").pattern("SAS").define(Character.valueOf('S'), AAEItems.SHATTERED_SINGULARITY).define(Character.valueOf('A'), AAEBlocks.QUANTUM_ACCELERATOR).define(Character.valueOf('K'), (ItemLike)AEItems.CELL_COMPONENT_64K).define(Character.valueOf('U'), AAEBlocks.QUANTUM_UNIT).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.SHATTERED_SINGULARITY)).save(c, AdvancedAE.makeId("quantumcrafter"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEBlocks.QUANTUM_ALLOY_BLOCK).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), AAEItems.QUANTUM_ALLOY).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("quantum_alloy_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AAEItems.QUANTUM_ALLOY, (int)9).requires(AAEBlocks.QUANTUM_ALLOY_BLOCK).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("quantum_alloy_from_block"));
        this.stairRecipe(c, AAEBlocks.QUANTUM_ALLOY_BLOCK, AAEBlocks.QUANTUM_ALLOY_STAIRS);
        this.wallRecipe(c, AAEBlocks.QUANTUM_ALLOY_BLOCK, AAEBlocks.QUANTUM_ALLOY_WALL);
        this.slabRecipe(c, AAEBlocks.QUANTUM_ALLOY_BLOCK, AAEBlocks.QUANTUM_ALLOY_SLAB);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.STOCK_EXPORT_BUS).pattern("   ").pattern("CEL").pattern("   ").define(Character.valueOf('E'), (ItemLike)AEParts.EXPORT_BUS).define(Character.valueOf('C'), (ItemLike)AEItems.CALCULATION_PROCESSOR).define(Character.valueOf('L'), (ItemLike)AEItems.LOGIC_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEParts.EXPORT_BUS)).save(c, AdvancedAE.makeId("stock_export_bus"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.IMPORT_EXPORT_BUS).pattern("   ").pattern("ILE").pattern("   ").define(Character.valueOf('I'), (ItemLike)AEParts.IMPORT_BUS).define(Character.valueOf('L'), (ItemLike)AEItems.LOGIC_PROCESSOR).define(Character.valueOf('E'), (ItemLike)AEParts.EXPORT_BUS).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEParts.EXPORT_BUS)).save(c, AdvancedAE.makeId("import_export_bus"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.ADVANCED_IO_BUS).pattern("AQA").pattern("IQS").pattern("AQA").define(Character.valueOf('I'), AAEItems.IMPORT_EXPORT_BUS).define(Character.valueOf('A'), (ItemLike)AEItems.SPEED_CARD).define(Character.valueOf('Q'), AAEItems.QUANTUM_PROCESSOR).define(Character.valueOf('S'), AAEItems.STOCK_EXPORT_BUS).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEParts.EXPORT_BUS)).save(c, AdvancedAE.makeId("advanced_io_bus"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.ADV_PATTERN_ENCODER).pattern("QRQ").pattern("RER").pattern("QRQ").define(Character.valueOf('Q'), (ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('E'), (ItemLike)AEItems.ENGINEERING_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEItems.BLANK_PATTERN)).save(c, AdvancedAE.makeId("advpartenc"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.ADV_PATTERN_PROVIDER_UPGRADE).pattern("IR").pattern("EL").define(Character.valueOf('I'), Tags.Items.INGOTS).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('E'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('L'), (ItemLike)AEItems.LOGIC_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEItems.BLANK_PATTERN)).save(c, AdvancedAE.makeId("smallappupgrade"));
        CrystalAssemblerRecipeBuilder.assemble(AAEItems.ADV_PATTERN_PROVIDER_CAPACITY_UPGRADE).input(Tags.Items.INGOTS).input((ItemLike)AEItems.CAPACITY_CARD, 3).input((ItemLike)Items.CRAFTING_TABLE, 3).input((ItemLike)EAESingletons.CONCURRENT_PROCESSOR).input(ConventionTags.GLASS_CABLE, 6).save(Addons.EXTENDEDAE.conditionalRecipe(c), AdvancedAE.makeId("eaelargeappupgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.ADV_PATTERN_PROVIDER_CAPACITY_UPGRADE).pattern("STS").pattern("GIG").pattern("CCC").define(Character.valueOf('I'), Tags.Items.INGOTS).define(Character.valueOf('C'), (ItemLike)AEItems.CAPACITY_CARD).define(Character.valueOf('T'), (ItemLike)Items.CRAFTING_TABLE).define(Character.valueOf('G'), ConventionTags.GLASS_CABLE).define(Character.valueOf('S'), AAEItems.SHATTERED_SINGULARITY).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.SHATTERED_SINGULARITY)).save(Addons.EXTENDEDAE.notConditionalRecipe(c), AdvancedAE.makeId("largeappupgrade"));
        ReactionChamberRecipeBuilder.react(AAEItems.SHATTERED_SINGULARITY, 2, 200000).input((ItemLike)AEItems.SINGULARITY).input((TagKey<Item>)ConventionTags.ENDER_PEARL_DUST, 2).input((ItemLike)AEItems.SKY_DUST, 2).fluid((Fluid)Fluids.LAVA, 100).save(c, "shatteredsingularity");
        InscriberRecipeBuilder.inscribe(AAEItems.SHATTERED_SINGULARITY, AAEItems.QUANTUM_INFUSED_DUST, (int)1).setMode(InscriberProcessType.PRESS).save(c, AdvancedAE.makeId("quantum_infused_dust"));
        ItemStackToItemStackRecipeBuilder.crushing((ItemStackIngredient)IngredientCreatorAccess.item().from(AAEItems.SHATTERED_SINGULARITY), (ItemStack)AAEItems.QUANTUM_INFUSED_DUST.stack()).build(Addons.MEKANISM.conditionalRecipe(c), AdvancedAE.makeId("quantum_infused_dust_crushed"));
        ReactionChamberRecipeBuilder.react(AAEItems.QUANTUM_ALLOY, 1, 200000).input((ItemLike)Items.COPPER_INGOT, 4).input((ItemLike)AAEItems.SHATTERED_SINGULARITY, 4).input((ItemLike)AEItems.SINGULARITY, 4).fluid(AAEFluids.QUANTUM_INFUSION.source(), 1000).save(c, "quantum_alloy");
        ReactionChamberRecipeBuilder.react(AAEItems.QUANTUM_ALLOY_PLATE, 1, 1000000).input((ItemLike)AAEItems.QUANTUM_ALLOY, 8).input((ItemLike)Items.NETHERITE_INGOT, 2).input((ItemLike)Items.NETHER_STAR, 1).fluid(AAEFluids.QUANTUM_INFUSION.source(), 1000).save(c, "quantum_alloy_plate");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AAEItems.THROUGHPUT_MONITOR).requires((ItemLike)AEItems.CALCULATION_PROCESSOR).requires((ItemLike)AEParts.STORAGE_MONITOR).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEParts.STORAGE_MONITOR)).save(c, AdvancedAE.makeId("throughput_monitor"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AAEItems.QUANTUM_CRAFTER_TERMINAL).requires((ItemLike)AEParts.PATTERN_ACCESS_TERMINAL).requires(AAEItems.QUANTUM_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has(AAEBlocks.QUANTUM_CRAFTER)).save(c, AdvancedAE.makeId("quantum_crafter_terminal"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.QUANTUM_CRAFTER_WIRELESS_TERMINAL).pattern(" W ").pattern(" T ").pattern(" C ").define(Character.valueOf('W'), (ItemLike)AEItems.WIRELESS_RECEIVER).define(Character.valueOf('T'), AAEItems.QUANTUM_CRAFTER_TERMINAL).define(Character.valueOf('C'), (ItemLike)AEBlocks.DENSE_ENERGY_CELL).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_CRAFTER_TERMINAL)).save(c, AdvancedAE.makeId("wireless_quantum_crafter_terminal"));
        InscriberRecipeBuilder.inscribe(AAEItems.SHATTERED_SINGULARITY, AAEItems.QUANTUM_PROCESSOR_PRESS, (int)1).setTop(Ingredient.of((ItemLike[])new ItemLike[]{AEItems.ENGINEERING_PROCESSOR_PRESS})).setBottom(Ingredient.of((ItemLike[])new ItemLike[]{AEItems.LOGIC_PROCESSOR_PRESS})).setMode(InscriberProcessType.PRESS).save(c, AdvancedAE.makeId("quantum_processor_press"));
        InscriberRecipeBuilder.inscribe((ItemLike)Items.IRON_BLOCK, AAEItems.QUANTUM_PROCESSOR_PRESS, (int)1).setTop(Ingredient.of((ItemLike[])new ItemLike[]{AAEItems.QUANTUM_PROCESSOR_PRESS})).setMode(InscriberProcessType.INSCRIBE).save(c, AdvancedAE.makeId("quantum_processor_press_from_iron"));
        InscriberRecipeBuilder.inscribe(AAEItems.QUANTUM_ALLOY, AAEItems.QUANTUM_PROCESSOR_PRINT, (int)1).setTop(Ingredient.of((ItemLike[])new ItemLike[]{AAEItems.QUANTUM_PROCESSOR_PRESS})).setMode(InscriberProcessType.INSCRIBE).save(c, AdvancedAE.makeId("quantum_processor_print"));
        CircuitCutterRecipeBuilder.cut(AAEItems.QUANTUM_PROCESSOR_PRINT, (int)9).input(AAEBlocks.QUANTUM_ALLOY_BLOCK, 1).save(Addons.EXTENDEDAE.conditionalRecipe(c), AdvancedAE.makeId("quantum_processor_print_eae"));
        InscriberRecipeBuilder.inscribe((TagKey)ConventionTags.REDSTONE, AAEItems.QUANTUM_PROCESSOR, (int)1).setTop(Ingredient.of((ItemLike[])new ItemLike[]{AAEItems.QUANTUM_PROCESSOR_PRINT})).setBottom(Ingredient.of((ItemLike[])new ItemLike[]{AEItems.SILICON_PRINT})).setMode(InscriberProcessType.PRESS).save(c, AdvancedAE.makeId("quantum_processor"));
        CrystalAssemblerRecipeBuilder.assemble(AAEItems.QUANTUM_PROCESSOR, (int)4).input(AAEItems.QUANTUM_PROCESSOR_PRINT, 4).input((ItemLike)AEItems.SILICON_PRINT, 4).input(ConventionTags.REDSTONE, 4).save(c, AdvancedAE.makeId("quantum_processor_eae"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.QUANTUM_STORAGE_COMPONENT).pattern("PSP").pattern("CQC").pattern("PCP").define(Character.valueOf('P'), AAEItems.QUANTUM_PROCESSOR).define(Character.valueOf('S'), (ItemLike)AEItems.SPATIAL_2_CELL_COMPONENT).define(Character.valueOf('C'), (ItemLike)AEItems.CELL_COMPONENT_256K).define(Character.valueOf('Q'), (ItemLike)AEBlocks.QUARTZ_VIBRANT_GLASS).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_PROCESSOR)).save(c, AdvancedAE.makeId("quantum_storage_component"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.MONITOR_CONFIGURATOR).pattern("  S").pattern(" I ").pattern("I  ").define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('S'), (ItemLike)AEItems.SPEED_CARD).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_PROCESSOR)).save(c, AdvancedAE.makeId("throughput_monitor_configurator"));
        ReactionChamberRecipeBuilder.react(AAEFluids.QUANTUM_INFUSION.source(), 1000, 20000).input((ItemLike)AAEItems.QUANTUM_INFUSED_DUST).fluid((Fluid)Fluids.WATER, 4000).save(c, "quantum_infusion");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEBlocks.QUANTUM_STRUCTURE).pattern("QSQ").pattern("S S").pattern("QSQ").define(Character.valueOf('Q'), (ItemLike)AEBlocks.QUARTZ_GLASS).define(Character.valueOf('S'), (ItemLike)AEBlocks.SKY_STONE_BLOCK).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEItems.SINGULARITY)).save(c, AdvancedAE.makeId("quantumstructure"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AAEBlocks.QUANTUM_UNIT).requires((ItemLike)AEBlocks.CRAFTING_UNIT).requires((ItemLike)AEItems.SINGULARITY).requires((ItemLike)EAESingletons.CONCURRENT_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEItems.SINGULARITY)).save(Addons.EXTENDEDAE.conditionalRecipe(c), AdvancedAE.makeId("eaequantumunit"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AAEBlocks.QUANTUM_UNIT).requires((ItemLike)AEBlocks.CRAFTING_UNIT).requires((ItemLike)AEItems.SINGULARITY).requires(AAEItems.SHATTERED_SINGULARITY, 2).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEItems.SINGULARITY)).save(Addons.EXTENDEDAE.notConditionalRecipe(c), AdvancedAE.makeId("quantumunit"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEBlocks.QUANTUM_ACCELERATOR).pattern("ECE").pattern("CUC").pattern("ECE").define(Character.valueOf('E'), AAEItems.SHATTERED_SINGULARITY).define(Character.valueOf('C'), (ItemLike)EAESingletons.CONCURRENT_PROCESSOR).define(Character.valueOf('U'), AAEBlocks.QUANTUM_UNIT).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEItems.SINGULARITY)).save(Addons.EXTENDEDAE.conditionalRecipe(c), AdvancedAE.makeId("eaequantumaccel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEBlocks.QUANTUM_ACCELERATOR).pattern("ESE").pattern("SUS").pattern("ESE").define(Character.valueOf('E'), AAEItems.SHATTERED_SINGULARITY).define(Character.valueOf('S'), (ItemLike)AEItems.SINGULARITY).define(Character.valueOf('U'), AAEBlocks.QUANTUM_UNIT).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEItems.SINGULARITY)).save(Addons.EXTENDEDAE.notConditionalRecipe(c), AdvancedAE.makeId("quantumaccel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEBlocks.QUANTUM_STORAGE_128M).pattern("ECE").pattern("CUC").pattern("ECE").define(Character.valueOf('E'), AAEItems.SHATTERED_SINGULARITY).define(Character.valueOf('C'), AAEItems.QUANTUM_STORAGE_COMPONENT).define(Character.valueOf('U'), AAEBlocks.QUANTUM_UNIT).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEItems.SINGULARITY)).save(c, AdvancedAE.makeId("quantumstorage128"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, AAEBlocks.QUANTUM_STORAGE_256M).requires(AAEItems.SHATTERED_SINGULARITY).requires(AAEBlocks.QUANTUM_STORAGE_128M).requires(AAEBlocks.QUANTUM_STORAGE_128M).requires(AAEBlocks.QUANTUM_UNIT).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEItems.SINGULARITY)).save(c, AdvancedAE.makeId("quantumstorage256"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEBlocks.QUANTUM_CORE).pattern("SES").pattern("AUT").pattern("SES").define(Character.valueOf('S'), (ItemLike)AEItems.SINGULARITY).define(Character.valueOf('E'), AAEItems.SHATTERED_SINGULARITY).define(Character.valueOf('U'), AAEBlocks.QUANTUM_UNIT).define(Character.valueOf('A'), AAEBlocks.QUANTUM_ACCELERATOR).define(Character.valueOf('T'), AAEBlocks.QUANTUM_STORAGE_256M).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)AEItems.SINGULARITY)).save(c, AdvancedAE.makeId("quantumcore"));
        CrystalAssemblerRecipeBuilder.assemble(AAEBlocks.DATA_ENTANGLER).input(AAEBlocks.QUANTUM_UNIT).input(AAEBlocks.QUANTUM_CORE).input(AAEItems.SHATTERED_SINGULARITY, 8).input(AAEBlocks.QUANTUM_STORAGE_256M, 3).save(Addons.EXTENDEDAE.conditionalRecipe(c), AdvancedAE.makeId("eaequantumdataentangler"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEBlocks.DATA_ENTANGLER).pattern("QQQ").pattern("SUS").pattern("SCS").define(Character.valueOf('U'), AAEBlocks.QUANTUM_UNIT).define(Character.valueOf('C'), AAEBlocks.QUANTUM_CORE).define(Character.valueOf('S'), AAEItems.SHATTERED_SINGULARITY).define(Character.valueOf('Q'), AAEBlocks.QUANTUM_STORAGE_256M).unlockedBy("hasItem", AAERecipeProvider.has(AAEBlocks.QUANTUM_UNIT)).save(Addons.EXTENDEDAE.notConditionalRecipe(c), AdvancedAE.makeId("quantumdataentangler"));
        CrystalAssemblerRecipeBuilder.assemble(AAEBlocks.QUANTUM_MULTI_THREADER).input(AAEBlocks.QUANTUM_UNIT).input(AAEBlocks.QUANTUM_CORE).input(AAEItems.SHATTERED_SINGULARITY, 8).input(AAEBlocks.QUANTUM_ACCELERATOR, 4).input((ItemLike)EAESingletons.CONCURRENT_PROCESSOR, 8).save(Addons.EXTENDEDAE.conditionalRecipe(c), AdvancedAE.makeId("eaequantummultithreader"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEBlocks.QUANTUM_MULTI_THREADER).pattern("SSS").pattern("AUA").pattern("ACA").define(Character.valueOf('U'), AAEBlocks.QUANTUM_UNIT).define(Character.valueOf('C'), AAEBlocks.QUANTUM_CORE).define(Character.valueOf('S'), AAEItems.SHATTERED_SINGULARITY).define(Character.valueOf('A'), AAEBlocks.QUANTUM_ACCELERATOR).unlockedBy("hasItem", AAERecipeProvider.has(AAEBlocks.QUANTUM_UNIT)).save(Addons.EXTENDEDAE.notConditionalRecipe(c), AdvancedAE.makeId("quantummultithreader"));
        ReactionChamberRecipeBuilder.react((ItemLike)AEItems.SINGULARITY, 1000000).input((ItemLike)AEItems.MATTER_BALL, 64).fluid((Fluid)Fluids.LAVA, 100).save(c, "singularity");
        ReactionChamberRecipeBuilder.react((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL, 64, 50000).input((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, 16).input((TagKey<Item>)ConventionTags.CERTUS_QUARTZ_DUST, 16).fluid((Fluid)Fluids.WATER, 500).save(c, "quartzcrystal");
        ReactionChamberRecipeBuilder.react((ItemLike)AEItems.FLUIX_CRYSTAL, 64, 200000).input((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, 16).input((ItemLike)Items.REDSTONE, 16).input((ItemLike)Items.QUARTZ, 16).fluid((Fluid)Fluids.WATER, 500).save(c, "fluixcrystals");
        ReactionChamberRecipeBuilder.react((ItemLike)AEItems.FLUIX_CRYSTAL, 64, 100000).input((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, 32).input((ItemLike)AEItems.FLUIX_DUST, 32).fluid((Fluid)Fluids.WATER, 500).save(c, "fluixcrystalfromdust");
        ReactionChamberRecipeBuilder.react((ItemLike)EAESingletons.ENTRO_CRYSTAL, 64, 100000).input((ItemLike)EAESingletons.ENTRO_DUST, 32).input((ItemLike)AEItems.FLUIX_CRYSTAL, 32).fluid((Fluid)Fluids.WATER, 500).save(Addons.EXTENDEDAE.conditionalRecipe(c), "entrocrystal");
        ReactionChamberRecipeBuilder.react((ItemLike)AEBlocks.DAMAGED_BUDDING_QUARTZ, 8, 100000).input((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, 8).input((ItemLike)AEBlocks.QUARTZ_BLOCK, 8).fluid((Fluid)Fluids.WATER, 1000).save(c, "damagedbudding");
        ReactionChamberRecipeBuilder.react((ItemLike)AEBlocks.CHIPPED_BUDDING_QUARTZ, 8, 200000).input((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, 8).input((ItemLike)AEBlocks.DAMAGED_BUDDING_QUARTZ, 8).fluid((Fluid)Fluids.WATER, 1000).save(c, "chippedbudding");
        ReactionChamberRecipeBuilder.react((ItemLike)AEBlocks.FLAWED_BUDDING_QUARTZ, 8, 300000).input((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, 8).input((ItemLike)AEBlocks.CHIPPED_BUDDING_QUARTZ, 8).fluid((Fluid)Fluids.WATER, 1000).save(c, "flawedbudding");
        ReactionChamberRecipeBuilder.react((ItemLike)EAESingletons.ENTRO_INGOT, 64, 500000).input((ItemLike)EAESingletons.ENTRO_DUST, 32).input((ItemLike)Items.GOLD_INGOT, 32).input((ItemLike)Items.LAPIS_LAZULI, 32).fluid((Fluid)Fluids.WATER, 500).save(Addons.EXTENDEDAE.conditionalRecipe(c), "entroingot");
        ReactionChamberRecipeBuilder.react((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, 64, 1300000).input((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL, 64).fluid((Fluid)Fluids.WATER, 1000).save(c, "certuscharger");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.QUANTUM_HELMET).pattern("PWP").pattern("PNP").pattern("AQA").define(Character.valueOf('N'), (ItemLike)Items.NETHERITE_HELMET).define(Character.valueOf('W'), (ItemLike)AEBlocks.WIRELESS_ACCESS_POINT).define(Character.valueOf('Q'), AAEItems.QUANTUM_STORAGE_COMPONENT).define(Character.valueOf('A'), AAEItems.QUANTUM_ALLOY_PLATE).define(Character.valueOf('P'), AAEItems.QUANTUM_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("quantum_helmet"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.QUANTUM_CHESTPLATE).pattern("PWP").pattern("PNP").pattern("AQA").define(Character.valueOf('N'), (ItemLike)Items.NETHERITE_CHESTPLATE).define(Character.valueOf('W'), (ItemLike)AEBlocks.WIRELESS_ACCESS_POINT).define(Character.valueOf('Q'), AAEItems.QUANTUM_STORAGE_COMPONENT).define(Character.valueOf('A'), AAEItems.QUANTUM_ALLOY_PLATE).define(Character.valueOf('P'), AAEItems.QUANTUM_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("quantum_chest"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.QUANTUM_LEGGINGS).pattern("PWP").pattern("PNP").pattern("AQA").define(Character.valueOf('N'), (ItemLike)Items.NETHERITE_LEGGINGS).define(Character.valueOf('W'), (ItemLike)AEBlocks.WIRELESS_ACCESS_POINT).define(Character.valueOf('Q'), AAEItems.QUANTUM_STORAGE_COMPONENT).define(Character.valueOf('A'), AAEItems.QUANTUM_ALLOY_PLATE).define(Character.valueOf('P'), AAEItems.QUANTUM_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("quantum_leggings"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.QUANTUM_BOOTS).pattern("PWP").pattern("PNP").pattern("AQA").define(Character.valueOf('N'), (ItemLike)Items.NETHERITE_BOOTS).define(Character.valueOf('W'), (ItemLike)AEBlocks.WIRELESS_ACCESS_POINT).define(Character.valueOf('Q'), AAEItems.QUANTUM_STORAGE_COMPONENT).define(Character.valueOf('A'), AAEItems.QUANTUM_ALLOY_PLATE).define(Character.valueOf('P'), AAEItems.QUANTUM_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("quantum_boots"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.QUANTUM_UPGRADE_BASE).pattern(" Q ").pattern("QPQ").pattern(" Q ").define(Character.valueOf('Q'), AAEItems.QUANTUM_PROCESSOR).define(Character.valueOf('P'), AAEItems.QUANTUM_ALLOY_PLATE).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("quantum_base_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.WALK_SPEED_CARD).pattern(" R ").pattern("ACA").pattern(" R ").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('R'), ConventionTags.REDSTONE).define(Character.valueOf('A'), (ItemLike)AEItems.SPEED_CARD).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("walk_speed_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.SPRINT_SPEED_CARD).pattern("ARA").pattern("RCR").pattern("ARA").define(Character.valueOf('R'), ConventionTags.REDSTONE).define(Character.valueOf('A'), (ItemLike)AEItems.SPEED_CARD).define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("sprint_speed_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.STEP_ASSIST_CARD).pattern(" S ").pattern("SCS").pattern(" S ").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('S'), AAEBlocks.QUANTUM_ALLOY_STAIRS).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("step_assist_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.JUMP_HEIGHT_CARD).pattern(" C ").pattern(" G ").pattern("BEB").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('G'), (ItemLike)Items.GUNPOWDER).define(Character.valueOf('B'), (ItemLike)Items.BLAZE_POWDER).define(Character.valueOf('E'), (ItemLike)Items.END_CRYSTAL).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("jump_height_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.LAVA_IMMUNITY_CARD).pattern(" T ").pattern(" C ").pattern("QLQ").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('T'), (ItemLike)Items.TOTEM_OF_UNDYING).define(Character.valueOf('L'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('Q'), (ItemLike)AEBlocks.QUARTZ_GLASS).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("lava_immunity_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.FLIGHT_CARD).pattern("PEP").pattern("FCF").pattern("PTP").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('E'), (ItemLike)Items.ELYTRA).define(Character.valueOf('F'), (ItemLike)Items.FEATHER).define(Character.valueOf('T'), (ItemLike)Items.TNT).define(Character.valueOf('P'), AAEItems.QUANTUM_ALLOY_PLATE).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("flight_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.WATER_BREATHING_CARD).pattern(" E ").pattern("PCP").pattern(" H ").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('E'), (ItemLike)AEItems.ENTROPY_MANIPULATOR).define(Character.valueOf('H'), (ItemLike)Items.HEART_OF_THE_SEA).define(Character.valueOf('P'), (ItemLike)Items.PUFFERFISH).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("water_breathing_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.AUTO_FEED_CARD).pattern(" W ").pattern("ACM").pattern(" E ").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('E'), (ItemLike)Items.ENCHANTED_GOLDEN_APPLE).define(Character.valueOf('A'), (ItemLike)Items.GOLDEN_CARROT).define(Character.valueOf('M'), (ItemLike)Items.GLISTERING_MELON_SLICE).define(Character.valueOf('W'), (ItemLike)AEBlocks.WIRELESS_ACCESS_POINT).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("auto_feed_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.AUTO_STOCK_CARD).pattern(" W ").pattern("BCB").pattern(" M ").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('W'), (ItemLike)AEBlocks.WIRELESS_ACCESS_POINT).define(Character.valueOf('B'), (ItemLike)Items.SHULKER_BOX).define(Character.valueOf('M'), (ItemLike)AEBlocks.CONTROLLER).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("auto_stock_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.MAGNET_CARD).pattern("IIA").pattern("IC ").pattern("IIA").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('A'), AAEItems.QUANTUM_ALLOY).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("magnet_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.HP_BUFFER_CARD).pattern(" T ").pattern("ICO").pattern(" E ").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('T'), (ItemLike)Items.TOTEM_OF_UNDYING).define(Character.valueOf('I'), (ItemLike)AEParts.IMPORT_BUS).define(Character.valueOf('O'), (ItemLike)AEParts.EXPORT_BUS).define(Character.valueOf('E'), (ItemLike)AEItems.PORTABLE_ITEM_CELL64K).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("hp_buffer_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.EVASION_CARD).pattern("PSP").pattern("HCH").pattern("PSP").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('H'), (ItemLike)Items.RABBIT_HIDE).define(Character.valueOf('S'), (ItemLike)AEItems.SPEED_CARD).define(Character.valueOf('P'), AAEItems.QUANTUM_ALLOY_PLATE).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("evasion_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.REGENERATION_CARD).pattern(" A ").pattern("RCM").pattern(" O ").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('A'), (ItemLike)Items.CAKE).define(Character.valueOf('R'), (ItemLike)Items.COOKED_RABBIT).define(Character.valueOf('M'), (ItemLike)Items.MUSHROOM_STEW).define(Character.valueOf('O'), (ItemLike)Items.COOKIE).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("regeneration_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.STRENGTH_CARD).pattern(" N ").pattern("FCQ").pattern(" D ").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('N'), (ItemLike)Items.NETHERITE_SWORD).define(Character.valueOf('F'), (ItemLike)AEItems.FLUIX_SWORD).define(Character.valueOf('Q'), (ItemLike)AEItems.CERTUS_QUARTZ_SWORD).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND_SWORD).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("strength_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.ATTACK_SPEED_CARD).pattern("SSS").pattern("QCQ").pattern("SSS").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('S'), (ItemLike)AEItems.SPEED_CARD).define(Character.valueOf('Q'), AAEItems.QUANTUM_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("attack_speed_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.LUCK_CARD).pattern("AFA").pattern("NCN").pattern("AFA").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('F'), (ItemLike)Items.RABBIT_FOOT).define(Character.valueOf('A'), (ItemLike)Blocks.AMETHYST_BLOCK).define(Character.valueOf('N'), (ItemLike)Items.NETHER_STAR).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("luck_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.REACH_CARD).pattern("E E").pattern("OCO").pattern("S S").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('E'), (ItemLike)Items.END_ROD).define(Character.valueOf('O'), (ItemLike)Items.LIGHTNING_ROD).define(Character.valueOf('S'), (ItemLike)Items.ECHO_SHARD).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("reach_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.SWIM_SPEED_CARD).pattern(" B ").pattern("HCH").pattern(" R ").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('B'), (ItemLike)Items.OAK_BOAT).define(Character.valueOf('R'), (ItemLike)Items.FIREWORK_ROCKET).define(Character.valueOf('H'), (ItemLike)Items.HEART_OF_THE_SEA).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("swim_speed_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.NIGHT_VISION_CARD).pattern(" B ").pattern("GCG").pattern(" S ").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('B'), (ItemLike)Items.BEACON).define(Character.valueOf('S'), (ItemLike)Items.SEA_LANTERN).define(Character.valueOf('G'), (ItemLike)Items.GLOWSTONE_DUST).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("night_vision_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.FLIGHT_DRIFT_CARD).pattern(" R ").pattern("QCQ").pattern(" L ").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('R'), (ItemLike)Items.RECOVERY_COMPASS).define(Character.valueOf('L'), (ItemLike)Blocks.LODESTONE).define(Character.valueOf('Q'), AAEItems.QUANTUM_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("flight_drift_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.RECHARGING_CARD).pattern("SWS").pattern("QCQ").pattern("EDE").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('W'), (ItemLike)AEBlocks.WIRELESS_ACCESS_POINT).define(Character.valueOf('S'), (ItemLike)AEItems.CHARGED_STAFF).define(Character.valueOf('Q'), AAEItems.QUANTUM_PROCESSOR).define(Character.valueOf('E'), (ItemLike)AEItems.ENERGY_CARD).define(Character.valueOf('D'), (ItemLike)AEBlocks.DENSE_ENERGY_CELL).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("recharging_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.WORKBENCH_CARD).pattern(" W ").pattern("PCP").pattern("ABA").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('W'), (ItemLike)AEBlocks.WIRELESS_ACCESS_POINT).define(Character.valueOf('B'), (ItemLike)AEBlocks.CELL_WORKBENCH).define(Character.valueOf('A'), AAEItems.QUANTUM_ALLOY).define(Character.valueOf('P'), AAEItems.QUANTUM_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("portable_workbench_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.PICK_CRAFT_CARD).pattern(" W ").pattern("PCP").pattern("ABA").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('W'), (ItemLike)AEBlocks.WIRELESS_ACCESS_POINT).define(Character.valueOf('B'), (ItemLike)Blocks.CRAFTING_TABLE).define(Character.valueOf('A'), AAEItems.QUANTUM_ALLOY).define(Character.valueOf('P'), AAEItems.QUANTUM_PROCESSOR).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("pick_craft_card"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AAEItems.CAMO_CARD).pattern(" G ").pattern("FCF").pattern("NNN").define(Character.valueOf('C'), AAEItems.QUANTUM_UPGRADE_BASE).define(Character.valueOf('G'), (ItemLike)Items.GOLDEN_CARROT).define(Character.valueOf('F'), (ItemLike)Items.FERMENTED_SPIDER_EYE).define(Character.valueOf('N'), (ItemLike)Items.NETHER_WART).unlockedBy("hasItem", AAERecipeProvider.has(AAEItems.QUANTUM_ALLOY)).save(c, AdvancedAE.makeId("camo_card"));
        this.resetNbtRecipe(c, AAEItems.QUANTUM_HELMET);
        this.resetNbtRecipe(c, AAEItems.QUANTUM_CHESTPLATE);
        this.resetNbtRecipe(c, AAEItems.QUANTUM_LEGGINGS);
        this.resetNbtRecipe(c, AAEItems.QUANTUM_BOOTS);
        this.loadAppFluxRecipes(c);
        this.loadMegaCellsRecipes(c);
    }

    private void resetNbtRecipe(@NotNull RecipeOutput c, BlockDefinition<?> block) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, block).requires(block).unlockedBy("hasItem", AAERecipeProvider.has(block)).save(c, AdvancedAE.makeId(block.id().getPath() + "_block_reset"));
    }

    private void resetNbtRecipe(@NotNull RecipeOutput c, ItemDefinition<?> item) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, item).requires(item).unlockedBy("hasItem", AAERecipeProvider.has(item)).save(c, AdvancedAE.makeId(item.id().getPath() + "_item_reset"));
    }

    private void loadAppFluxRecipes(@NotNull RecipeOutput c) {
        ReactionChamberRecipeBuilder.react((ItemLike)AFSingletons.REDSTONE_CRYSTAL, 64, 20000).input((ItemLike)Blocks.REDSTONE_BLOCK, 16).input((ItemLike)AEItems.FLUIX_CRYSTAL, 16).input((ItemLike)Items.GLOWSTONE_DUST, 16).fluid((Fluid)Fluids.WATER, 500).save(Addons.APPFLUX.conditionalRecipe(c), "redstonecrystal");
        ReactionChamberRecipeBuilder.react((ItemLike)AFSingletons.CHARGED_REDSTONE, 64, 1300000).input((ItemLike)AFSingletons.REDSTONE_CRYSTAL, 64).fluid((Fluid)Fluids.WATER, 1000).save(Addons.APPFLUX.conditionalRecipe(c), "chargedredstone");
    }

    private void loadMegaCellsRecipes(@NotNull RecipeOutput c) {
        ReactionChamberRecipeBuilder.react((ItemLike)MEGAItems.SKY_STEEL_INGOT, 64, 200000).input((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, 16).input((ItemLike)Items.IRON_INGOT, 16).input((ItemLike)AEBlocks.SKY_STONE_BLOCK, 16).fluid((Fluid)Fluids.LAVA, 500).save(Addons.MEGACELLS.conditionalRecipe(c), "skysteel");
        ReactionChamberRecipeBuilder.react((ItemLike)MEGAItems.SKY_BRONZE_INGOT, 64, 200000).input((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, 16).input((ItemLike)Items.COPPER_INGOT, 16).input((ItemLike)AEBlocks.SKY_STONE_BLOCK, 16).fluid((Fluid)Fluids.LAVA, 500).save(Addons.MEGACELLS.conditionalRecipe(c), "skybronze");
        ReactionChamberRecipeBuilder.react((ItemLike)MEGAItems.SKY_OSMIUM_INGOT, 64, 200000).input((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED, 16).input(AAEConventionTags.OSMIUM_INGOT, 16).input((ItemLike)AEBlocks.SKY_STONE_BLOCK, 16).fluid((Fluid)Fluids.LAVA, 500).save(c.withConditions(new ICondition[]{new AndCondition(List.of(new ModLoadedCondition(Addons.MEGACELLS.getModId()), new ModLoadedCondition(Addons.MEKANISM.getModId())))}), "skyosmium");
    }

    private void slabRecipe(RecipeOutput consumer, BlockDefinition<?> block, BlockDefinition<?> slabs) {
        Block inputBlock = block.block();
        Block outputBlock = slabs.block();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputBlock, (int)6).pattern("###").define(Character.valueOf('#'), (ItemLike)inputBlock).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)inputBlock)).save(consumer, String.valueOf(block.id()) + "_slab");
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputBlock}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)outputBlock, (int)2).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)inputBlock)).save(consumer, slabs.id());
    }

    private void stairRecipe(RecipeOutput consumer, BlockDefinition<?> block, BlockDefinition<?> stairs) {
        Block inputBlock = block.block();
        Block outputBlock = stairs.block();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputBlock, (int)4).pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), (ItemLike)inputBlock).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)inputBlock)).save(consumer, String.valueOf(block.id()) + "_stair");
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputBlock}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)outputBlock).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)inputBlock)).save(consumer, stairs.id());
    }

    private void wallRecipe(RecipeOutput consumer, BlockDefinition<?> block, BlockDefinition<?> wall) {
        Block inputBlock = block.block();
        Block outputBlock = wall.block();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputBlock, (int)6).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)inputBlock).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)inputBlock)).save(consumer, String.valueOf(block.id()) + "_wall");
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{inputBlock}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)outputBlock).unlockedBy("hasItem", AAERecipeProvider.has((ItemLike)inputBlock)).save(consumer, wall.id());
    }
}

