/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet.quantumarmor;

import appeng.api.stacks.GenericStack;
import appeng.core.network.CustomAppEngPayload;
import appeng.core.network.ServerboundPacket;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.gui.QuantumArmorConfigMenu;

public record QuantumArmorUpgradeFilterPacket(UpgradeType upgradeType, List<GenericStack> filter) implements ServerboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, QuantumArmorUpgradeFilterPacket> STREAM_CODEC = StreamCodec.ofMember(QuantumArmorUpgradeFilterPacket::write, QuantumArmorUpgradeFilterPacket::decode);
    public static final CustomPacketPayload.Type<QuantumArmorUpgradeFilterPacket> TYPE = CustomAppEngPayload.createType((String)"aae_upgrade_filter");

    public CustomPacketPayload.Type<QuantumArmorUpgradeFilterPacket> type() {
        return TYPE;
    }

    public static QuantumArmorUpgradeFilterPacket decode(RegistryFriendlyByteBuf stream) {
        UpgradeType upgradeType = (UpgradeType)stream.readEnum(UpgradeType.class);
        List filter = (List)GenericStack.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)stream);
        return new QuantumArmorUpgradeFilterPacket(upgradeType, filter);
    }

    public void write(RegistryFriendlyByteBuf data) {
        data.writeEnum((Enum)this.upgradeType);
        GenericStack.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)data, this.filter);
    }

    public void handleOnServer(ServerPlayer serverPlayer) {
        AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
        if (abstractContainerMenu instanceof QuantumArmorConfigMenu) {
            QuantumArmorConfigMenu menu = (QuantumArmorConfigMenu)abstractContainerMenu;
            menu.openFilterConfigScreen(this.upgradeType, this.filter);
        }
    }
}

