/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui.advpatternprovider;

import appeng.api.config.LockCraftingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.GenericStack;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.helpers.patternprovider.PatternProviderReturnInventory;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.util.ConfigMenuInventory;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.pedroksl.advanced_ae.api.AAESettings;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.logic.AdvPatternProviderLogic;
import net.pedroksl.advanced_ae.common.logic.AdvPatternProviderLogicHost;

public class AdvPatternProviderMenu
extends AEBaseMenu {
    protected final AdvPatternProviderLogic logic;
    @GuiSync(value=3)
    public YesNo blockingMode = YesNo.NO;
    @GuiSync(value=4)
    public YesNo showInAccessTerminal = YesNo.YES;
    @GuiSync(value=8)
    public YesNo filterInput = YesNo.NO;
    @GuiSync(value=5)
    public LockCraftingMode lockCraftingMode = LockCraftingMode.NONE;
    @GuiSync(value=6)
    public LockCraftingMode craftingLockedReason = LockCraftingMode.NONE;
    @GuiSync(value=7)
    public GenericStack unlockStack = null;

    public AdvPatternProviderMenu(int id, Inventory playerInventory, AdvPatternProviderLogicHost host) {
        this(AAEMenus.ADV_PATTERN_PROVIDER.get(), id, playerInventory, host);
    }

    protected AdvPatternProviderMenu(MenuType<? extends AdvPatternProviderMenu> menuType, int id, Inventory playerInventory, AdvPatternProviderLogicHost host) {
        super(menuType, id, playerInventory, (Object)host);
        this.createPlayerInventorySlots(playerInventory);
        this.logic = host.getLogic();
        InternalInventory patternInv = this.logic.getPatternInv();
        for (int x = 0; x < patternInv.size(); ++x) {
            this.addSlot((Slot)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, patternInv, x), SlotSemantics.ENCODED_PATTERN);
        }
        ConfigMenuInventory returnInv = this.logic.getReturnInv().createMenuWrapper();
        for (int i = 0; i < PatternProviderReturnInventory.NUMBER_OF_SLOTS; ++i) {
            if (i >= returnInv.size()) continue;
            this.addSlot((Slot)new AppEngSlot((InternalInventory)returnInv, i), SlotSemantics.STORAGE);
        }
    }

    public void broadcastChanges() {
        if (this.isServerSide()) {
            this.blockingMode = (YesNo)this.logic.getConfigManager().getSetting(Settings.BLOCKING_MODE);
            this.showInAccessTerminal = (YesNo)this.logic.getConfigManager().getSetting(Settings.PATTERN_ACCESS_TERMINAL);
            this.lockCraftingMode = (LockCraftingMode)this.logic.getConfigManager().getSetting(Settings.LOCK_CRAFTING_MODE);
            this.filterInput = (YesNo)this.logic.getConfigManager().getSetting(AAESettings.FILTERED_IMPORT);
            this.craftingLockedReason = this.logic.getCraftingLockedReason();
            this.unlockStack = this.logic.getUnlockStack();
        }
        super.broadcastChanges();
    }

    public GenericStackInv getReturnInv() {
        return this.logic.getReturnInv();
    }

    public YesNo getBlockingMode() {
        return this.blockingMode;
    }

    public LockCraftingMode getLockCraftingMode() {
        return this.lockCraftingMode;
    }

    public LockCraftingMode getCraftingLockedReason() {
        return this.craftingLockedReason;
    }

    public GenericStack getUnlockStack() {
        return this.unlockStack;
    }

    public YesNo getShowInAccessTerminal() {
        return this.showInAccessTerminal;
    }

    public YesNo getFilterInputMode() {
        return this.filterInput;
    }
}

