/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.helpers;

import appeng.api.AECapabilities;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.me.storage.ExternalStorageFacade;
import appeng.parts.automation.HandlerStrategy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.pedroksl.advanced_ae.common.helpers.StorageReader;

public class StorageReaderImpl<T, S>
implements StorageReader {
    private final BlockCapabilityCache<T, Direction> cache;
    private final BlockCapabilityCache<MEStorage, Direction> meCache;
    private final HandlerStrategy<T, S> conversion;

    public StorageReaderImpl(BlockCapability<T, Direction> capability, HandlerStrategy<T, S> conversion, ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.cache = BlockCapabilityCache.create(capability, (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
        this.meCache = BlockCapabilityCache.create((BlockCapability)AECapabilities.ME_STORAGE, (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
        this.conversion = conversion;
    }

    @Override
    public long getCurrentStock(AEKey what) {
        KeyCounter keys;
        if (what.getType() != this.conversion.getKeyType()) {
            return 0L;
        }
        MEStorage meHandler = (MEStorage)this.meCache.getCapability();
        if (meHandler != null && (keys = meHandler.getAvailableStacks()).get(what) > 0L) {
            return keys.get(what);
        }
        Object adjacentHandler = this.cache.getCapability();
        if (adjacentHandler == null) {
            return 0L;
        }
        ExternalStorageFacade adjacentStorage = this.conversion.getFacade(adjacentHandler);
        long amount = adjacentStorage.getAvailableStacks().get(what);
        return Math.max(0L, amount);
    }

    public static StorageReader item(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        return new StorageReaderImpl(Capabilities.ItemHandler.BLOCK, HandlerStrategy.ITEMS, level, fromPos, fromSide);
    }

    public static StorageReader fluid(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        return new StorageReaderImpl(Capabilities.FluidHandler.BLOCK, HandlerStrategy.FLUIDS, level, fromPos, fromSide);
    }
}

