/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.entities;

import appeng.api.ids.AEComponents;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.orientation.BlockOrientation;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AECableType;
import appeng.block.crafting.PatternProviderBlock;
import appeng.block.crafting.PushDirection;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.pedroksl.advanced_ae.common.blocks.AdvPatternProviderBlock;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.logic.AdvPatternProviderLogic;
import net.pedroksl.advanced_ae.common.logic.AdvPatternProviderLogicHost;
import org.jetbrains.annotations.Nullable;

public class AdvPatternProviderEntity
extends AENetworkedBlockEntity
implements AdvPatternProviderLogicHost {
    protected final AdvPatternProviderLogic logic;

    public AdvPatternProviderEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.logic = this.createLogic();
    }

    protected AdvPatternProviderEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState, int slots) {
        super(blockEntityType, pos, blockState);
        this.logic = this.createLogic(slots);
    }

    protected AdvPatternProviderLogic createLogic() {
        return this.createLogic(36);
    }

    protected AdvPatternProviderLogic createLogic(int slots) {
        return new AdvPatternProviderLogic(this.getMainNode(), this, slots);
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.logic.onMainNodeStateChanged();
        this.updateState();
    }

    public void updateState() {
        if (!this.getMainNode().isReady()) {
            return;
        }
        boolean connected = false;
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null && grid.getEnergyService().isNetworkPowered()) {
            connected = true;
        }
        if (this.checkPosition(this.worldPosition) && (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)AdvPatternProviderBlock.CONNECTION_STATE) != connected) {
            this.level.setBlock(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)AdvPatternProviderBlock.CONNECTION_STATE, (Comparable)Boolean.valueOf(connected)), 2);
        }
    }

    private boolean checkPosition(BlockPos pos) {
        return Platform.getTickingBlockEntity((Level)this.getLevel(), (BlockPos)pos) instanceof AdvPatternProviderEntity;
    }

    private PushDirection getPushDirection() {
        return (PushDirection)this.getBlockState().getValue((Property)PatternProviderBlock.PUSH_DIRECTION);
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        Direction pushDirection = this.getPushDirection().getDirection();
        if (pushDirection == null) {
            return EnumSet.allOf(Direction.class);
        }
        return EnumSet.complementOf(EnumSet.of(pushDirection));
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        this.logic.addDrops(drops);
    }

    public void clearContent() {
        super.clearContent();
        this.logic.clearContent();
    }

    public void onReady() {
        super.onReady();
        this.logic.updatePatterns();
        this.updateState();
    }

    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        this.logic.writeToNBT(data, registries);
    }

    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        super.loadTag(data, registries);
        this.logic.readFromNBT(data, registries);
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    @Override
    public AdvPatternProviderLogic getLogic() {
        return this.logic;
    }

    @Override
    public EnumSet<Direction> getTargets() {
        PushDirection pushDirection = this.getPushDirection();
        if (pushDirection.getDirection() == null) {
            return EnumSet.allOf(Direction.class);
        }
        return EnumSet.of(pushDirection.getDirection());
    }

    @Override
    public AEItemKey getTerminalIcon() {
        return AEItemKey.of(AAEBlocks.ADV_PATTERN_PROVIDER);
    }

    public void exportSettings(SettingsFrom mode, DataComponentMap.Builder builder, @Nullable Player player) {
        super.exportSettings(mode, builder, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            this.logic.exportSettings(builder);
            PushDirection pushDirection = this.getPushDirection();
            builder.set(AEComponents.EXPORTED_PUSH_DIRECTION, (Object)pushDirection);
        }
    }

    public void importSettings(SettingsFrom mode, DataComponentMap input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.MEMORY_CARD) {
            Level level;
            this.logic.importSettings(input, player);
            PushDirection pushDirection = (PushDirection)input.get(AEComponents.EXPORTED_PUSH_DIRECTION);
            if (pushDirection != null && (level = this.getLevel()) != null) {
                level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)PatternProviderBlock.PUSH_DIRECTION, (Comparable)pushDirection));
            }
        }
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack(AAEBlocks.ADV_PATTERN_PROVIDER);
    }

    public void setBlockState(BlockState state) {
        super.setBlockState(state);
        this.onGridConnectableSidesChanged();
    }
}

