/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.client.render;

import com.glodblock.github.ae2netanalyser.client.render.NetworkRender;
import com.glodblock.github.ae2netanalyser.client.render.ProfileDataHandler;
import com.glodblock.github.ae2netanalyser.common.AEASingletons;
import com.glodblock.github.ae2netanalyser.common.items.ItemTickAnalyzer;
import com.glodblock.github.ae2netanalyser.common.me.ticker.ProfileData;
import com.glodblock.github.glodium.client.render.ColorData;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.DoublePredicate;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class ProfileRender
extends RenderType {
    public static final ProfileRender INSTANCE = new ProfileRender();
    private static ItemStack currentProfiler;
    private static VertexBuffer VBO;
    private final RenderType CUBE_RENDER;
    private static final ColorData WHITE;
    private static final float CUBE_SIZE = 0.8f;

    public static void hook(RenderLevelStageEvent event) {
        LocalPlayer player;
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && (player = Minecraft.getInstance().player) != null && player.getMainHandItem().getItem() == AEASingletons.TICK_ANALYSER) {
            if (currentProfiler != player.getMainHandItem()) {
                currentProfiler = player.getMainHandItem();
                ProfileDataHandler.updateConfig((ItemTickAnalyzer.TickConfig)currentProfiler.getOrDefault(AEASingletons.TICK_CONFIG, (Object)ItemTickAnalyzer.defaultConfig));
            }
            INSTANCE.tick(event.getPoseStack(), Minecraft.getInstance().renderBuffers().bufferSource(), event.getProjectionMatrix(), event.getCamera(), (ResourceKey<Level>)player.level().dimension());
        }
    }

    public void createVBO(DoublePredicate filter, ResourceKey<Level> world, ProfileData data) {
        if (VBO != null) {
            VBO.close();
        }
        BufferBuilder buf = new BufferBuilder(new ByteBufferBuilder(this.CUBE_RENDER.bufferSize() * 8), this.CUBE_RENDER.mode(), this.CUBE_RENDER.format());
        PoseStack stack = new PoseStack();
        for (ProfileData.ATick tick : data.ticks) {
            if (!world.equals((Object)tick.pos().dimension()) || !filter.test(tick.rate())) continue;
            NetworkRender.INSTANCE.drawCube(0.8f, tick.color(), tick.pos().pos(), stack, buf);
        }
        MeshData rendered = buf.build();
        if (rendered != null) {
            VBO = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
            VBO.bind();
            VBO.upload(rendered);
            VertexBuffer.unbind();
        }
    }

    public void tick(PoseStack stack, MultiBufferSource.BufferSource multiBuf, Matrix4f pro, Camera camera, ResourceKey<Level> world) {
        if (ProfileDataHandler.pullData() == null || GameRenderer.getPositionColorShader() == null) {
            return;
        }
        if (camera.isInitialized()) {
            Vec3 offset = camera.getPosition().reverse();
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            DoublePredicate filter = ProfileDataHandler.renderFilter();
            if (ProfileDataHandler.update()) {
                this.createVBO(filter, world, ProfileDataHandler.pullData());
            }
            if (VBO != null) {
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.disableCull();
                stack.pushPose();
                Quaternionf rotation = new Quaternionf((Quaternionfc)camera.rotation());
                rotation.invert();
                stack.mulPose(rotation);
                stack.translate(offset.x, offset.y, offset.z);
                VBO.bind();
                VBO.drawWithShader(stack.last().pose(), pro, GameRenderer.getPositionColorShader());
                VertexBuffer.unbind();
                stack.popPose();
                RenderSystem.enableCull();
            }
            RenderSystem.disableBlend();
            for (ProfileData.ATick tick : ProfileDataHandler.pullData().ticks) {
                if (!world.equals((Object)tick.pos().dimension()) || !filter.test(tick.rate())) continue;
                NetworkRender.INSTANCE.drawInWorldText((int)tick.rate() + "\u03bcs/t", WHITE, tick.pos().pos().getCenter(), offset, camera, stack, (MultiBufferSource)multiBuf);
            }
            multiBuf.endBatch();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
    }

    public ProfileRender() {
        super("", DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES, 0, false, false, () -> {}, () -> {});
        this.CUBE_RENDER = NetworkRender.INSTANCE.CUBE_RENDER;
    }

    static {
        VBO = null;
        WHITE = new ColorData(1.0f, 1.0f, 1.0f);
    }
}

