/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.client.gui;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.menu.AEBaseMenu;
import com.glodblock.github.ae2netanalyser.client.gui.elements.ClickableArea;
import com.glodblock.github.ae2netanalyser.client.gui.elements.ColorArea;
import com.glodblock.github.ae2netanalyser.client.gui.elements.DrawableArea;
import com.glodblock.github.ae2netanalyser.common.items.ItemTickAnalyzer;
import com.glodblock.github.ae2netanalyser.container.ContainerProfiler;
import com.glodblock.github.ae2netanalyser.network.AEANetworkHandler;
import com.glodblock.github.ae2netanalyser.network.packets.CAnalyserGeneric;
import com.glodblock.github.ae2netanalyser.network.packets.CTickConfigSave;
import com.glodblock.github.ae2netanalyser.network.packets.CTickProfilerRequest;
import com.glodblock.github.glodium.client.render.ColorData;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;

public class GuiProfiler
extends AEBaseScreen<ContainerProfiler> {
    private static final ColorData RED = new ColorData(1.0f, 0.0f, 0.0f);
    private static final ColorData GREEN = new ColorData(0.0f, 1.0f, 0.0f);
    private int duration = 60;
    private final boolean[] enable = new boolean[4];
    private final ArrayList<ClickableArea> clickables = new ArrayList();
    private final EditBox durationInput;
    private final ColorArea[] dots = new ColorArea[4];

    public GuiProfiler(ContainerProfiler menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.durationInput = new EditBox(this.font, 32, 9, (Component)Component.empty());
        this.durationInput.setMaxLength(4);
        this.durationInput.setFilter(this::isNumber);
        this.durationInput.setResponder(this::setDuration);
        this.durationInput.setBordered(false);
        this.durationInput.setTextColor(0xFFFFFF);
        this.clickables.add(new ClickableArea(15, 98, 56, 19, (AbstractContainerScreen<?>)this, () -> AEANetworkHandler.INSTANCE.sendToServer(new CTickProfilerRequest(this.duration))));
        this.clickables.add(new ClickableArea(136, 98, 56, 19, (AbstractContainerScreen<?>)this, () -> AEANetworkHandler.INSTANCE.sendToServer(new CTickProfilerRequest(-1))));
        this.dots[0] = new ColorArea(83, 47, 4, 4, (AbstractContainerScreen<?>)this, () -> this.cycleEnable(0));
        this.clickables.add(this.dots[0]);
        this.dots[1] = new ColorArea(180, 47, 4, 4, (AbstractContainerScreen<?>)this, () -> this.cycleEnable(1));
        this.clickables.add(this.dots[1]);
        this.dots[2] = new ColorArea(83, 76, 4, 4, (AbstractContainerScreen<?>)this, () -> this.cycleEnable(2));
        this.clickables.add(this.dots[2]);
        this.dots[3] = new ColorArea(180, 76, 4, 4, (AbstractContainerScreen<?>)this, () -> this.cycleEnable(3));
        this.clickables.add(this.dots[3]);
        AEANetworkHandler.INSTANCE.sendToServer((IMessage)new CAnalyserGeneric("update"));
    }

    protected void init() {
        super.init();
        this.durationInput.setPosition(this.leftPos + 89, this.topPos + 23);
        this.addRenderableWidget((GuiEventListener)this.durationInput);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.disableDepthTest();
        for (ClickableArea c : this.clickables) {
            if (!(c instanceof DrawableArea)) continue;
            DrawableArea d = (DrawableArea)c;
            d.draw(guiGraphics);
        }
        RenderSystem.enableDepthTest();
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        for (ClickableArea c : this.clickables) {
            if (!c.click(xCoord, yCoord)) continue;
            return true;
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        this.drawCenteredText(guiGraphics, (Component)Component.translatable((String)"gui.ae2netanalyser.tick_analyser.set_duration"), 103, 11, textColor);
        this.drawCenteredText(guiGraphics, (Component)Component.translatable((String)"gui.ae2netanalyser.tick_analyser.begin"), 42, 107, -1);
        this.drawCenteredText(guiGraphics, (Component)Component.translatable((String)"gui.ae2netanalyser.tick_analyser.cancel"), 163, 107, -1);
        this.drawRightText(guiGraphics, (Component)Component.translatable((String)"gui.ae2netanalyser.tick_analyser.range1"), 80, 49, textColor);
        this.drawRightText(guiGraphics, (Component)Component.translatable((String)"gui.ae2netanalyser.tick_analyser.range2"), 177, 49, textColor);
        this.drawRightText(guiGraphics, (Component)Component.translatable((String)"gui.ae2netanalyser.tick_analyser.range3"), 80, 78, textColor);
        this.drawRightText(guiGraphics, (Component)Component.translatable((String)"gui.ae2netanalyser.tick_analyser.range4"), 177, 78, textColor);
    }

    private void drawCenteredText(GuiGraphics guiGraphics, Component text, int centerX, int centerY, int color) {
        int width = this.font.width((FormattedText)text);
        Objects.requireNonNull(this.font);
        int height = 9;
        guiGraphics.drawString(this.font, text, centerX - width / 2, centerY - height / 2, color, false);
    }

    private void drawRightText(GuiGraphics guiGraphics, Component text, int rightX, int rightY, int color) {
        int width = this.font.width((FormattedText)text);
        Objects.requireNonNull(this.font);
        int height = 9;
        guiGraphics.drawString(this.font, text, rightX - width, rightY - height / 2, color, false);
    }

    private void cycleEnable(int index) {
        this.enable[index] = !this.enable[index];
        this.dots[index].setColor(this.enable[index] ? GREEN : RED);
        AEANetworkHandler.INSTANCE.sendToServer(new CTickConfigSave(new ItemTickAnalyzer.TickConfig(this.duration, this.enable[0], this.enable[1], this.enable[2], this.enable[3])));
    }

    private void setDuration(String text) {
        try {
            this.duration = Integer.parseInt(text);
            if (this.duration <= 0) {
                this.duration = 1;
            }
        }
        catch (NumberFormatException e) {
            this.duration = 60;
        }
        AEANetworkHandler.INSTANCE.sendToServer(new CTickConfigSave(new ItemTickAnalyzer.TickConfig(this.duration, this.enable[0], this.enable[1], this.enable[2], this.enable[3])));
    }

    private boolean isNumber(String input) {
        for (char c : input.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public void loadConfig(ItemTickAnalyzer.TickConfig config) {
        this.duration = config.duration();
        this.enable[0] = config.op1();
        this.enable[1] = config.op2();
        this.enable[2] = config.op3();
        this.enable[3] = config.op4();
        this.durationInput.setValue(String.valueOf(this.duration));
        for (int x = 0; x < 4; ++x) {
            this.dots[x].setColor(this.enable[x] ? GREEN : RED);
        }
    }

    public void onClose() {
        AEANetworkHandler.INSTANCE.sendToServer(new CTickConfigSave(new ItemTickAnalyzer.TickConfig(this.duration, this.enable[0], this.enable[1], this.enable[2], this.enable[3])));
        super.onClose();
    }
}

