/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.client.gui;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.menu.AEBaseMenu;
import com.glodblock.github.ae2netanalyser.client.gui.elements.ClickableArea;
import com.glodblock.github.ae2netanalyser.client.gui.elements.ColorArea;
import com.glodblock.github.ae2netanalyser.client.gui.elements.DraggableArea;
import com.glodblock.github.ae2netanalyser.client.gui.elements.DrawableArea;
import com.glodblock.github.ae2netanalyser.client.gui.textures.Blitters;
import com.glodblock.github.ae2netanalyser.client.render.NetworkDataHandler;
import com.glodblock.github.ae2netanalyser.common.items.ItemNetworkAnalyzer;
import com.glodblock.github.ae2netanalyser.common.me.AnalyserMode;
import com.glodblock.github.ae2netanalyser.common.me.NetworkData;
import com.glodblock.github.ae2netanalyser.common.me.netdata.LinkFlag;
import com.glodblock.github.ae2netanalyser.common.me.netdata.NodeFlag;
import com.glodblock.github.ae2netanalyser.container.ContainerAnalyser;
import com.glodblock.github.ae2netanalyser.network.AEANetworkHandler;
import com.glodblock.github.ae2netanalyser.network.packets.CAnalyserConfigSave;
import com.glodblock.github.ae2netanalyser.network.packets.CAnalyserGeneric;
import com.glodblock.github.ae2netanalyser.util.Util;
import com.glodblock.github.glodium.client.render.ColorData;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.util.GlodUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;

public class GuiAnalyser
extends AEBaseScreen<ContainerAnalyser> {
    private float size = 0.4f;
    private AnalyserMode mode = AnalyserMode.FULL;
    private final Reference2ObjectMap<Enum<?>, ColorData> colors = new Reference2ObjectOpenHashMap();
    private final Reference2ObjectMap<Enum<?>, ColorArea> colorBtns = new Reference2ObjectOpenHashMap();
    private final ArrayList<ClickableArea> clickables = new ArrayList();
    private final ColorWindow colorWindow;
    private final DraggableArea colorRed;
    private final DraggableArea colorGreen;
    private final DraggableArea colorBlue;
    private final DraggableArea colorAlpha;
    private final ColorArea colorShow;
    private static final List<Enum<?>> COLOR_ORDER = List.of(LinkFlag.NORMAL, LinkFlag.DENSE, LinkFlag.COMPRESSED, NodeFlag.NORMAL, NodeFlag.DENSE, NodeFlag.MISSING);

    public GuiAnalyser(ContainerAnalyser menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.colors.putAll(ItemNetworkAnalyzer.defaultColors);
        this.clickables.add(new ClickableArea(39, 21, 6, 11, (AbstractContainerScreen<?>)this, () -> this.changeMode(-1)));
        this.clickables.add(new ClickableArea(107, 21, 6, 11, (AbstractContainerScreen<?>)this, () -> this.changeMode(1)));
        this.clickables.add(new ClickableArea(39, 49, 6, 11, (AbstractContainerScreen<?>)this, () -> this.changeSize(-0.1f)));
        this.clickables.add(new ClickableArea(107, 49, 6, 11, (AbstractContainerScreen<?>)this, () -> this.changeSize(0.1f)));
        this.clickables.add(new ClickableArea(146, 142, 65, 14, (AbstractContainerScreen<?>)this, this::loadDefault));
        for (int i = 0; i < COLOR_ORDER.size(); ++i) {
            Enum<?> mode = COLOR_ORDER.get(i);
            ColorArea btn = new ColorArea(198, 22 + i * 21, 25, 9, (AbstractContainerScreen<?>)this, () -> this.beginColorConfig(mode));
            this.clickables.add(btn);
            this.colorBtns.put(mode, (Object)btn);
        }
        this.colorWindow = new ColorWindow(73, 48, 110, 95, (AbstractContainerScreen<?>)this);
        this.colorRed = new DraggableArea(81, 57, 90, 7, (AbstractContainerScreen<?>)this);
        this.colorWindow.addElement(this.colorRed);
        this.colorGreen = new DraggableArea(81, 72, 90, 7, (AbstractContainerScreen<?>)this);
        this.colorWindow.addElement(this.colorGreen);
        this.colorBlue = new DraggableArea(81, 87, 90, 7, (AbstractContainerScreen<?>)this);
        this.colorWindow.addElement(this.colorBlue);
        this.colorAlpha = new DraggableArea(81, 102, 90, 7, (AbstractContainerScreen<?>)this);
        this.colorWindow.addElement(this.colorAlpha);
        this.colorShow = new ColorArea(114, 121, 27, 7, (AbstractContainerScreen<?>)this, () -> {});
        this.colorWindow.addElement(this.colorShow);
        this.colorWindow.addElement(new ClickableArea(90, 118, 13, 13, (AbstractContainerScreen<?>)this, () -> this.closeColorConfig(true)));
        this.colorWindow.addElement(new ClickableArea(152, 118, 13, 13, (AbstractContainerScreen<?>)this, () -> this.closeColorConfig(false)));
        AEANetworkHandler.INSTANCE.sendToServer((IMessage)new CAnalyserGeneric("update"));
    }

    public void loadConfig(ItemNetworkAnalyzer.AnalyserConfig config) {
        this.mode = config.mode();
        this.size = config.nodeSize();
        this.colors.clear();
        this.colors.putAll(config.colors());
        for (Map.Entry entry : this.colors.entrySet()) {
            ColorArea btn = (ColorArea)this.colorBtns.get(entry.getKey());
            btn.setColor((ColorData)entry.getValue());
        }
    }

    public void loadDefault() {
        this.colors.clear();
        this.colors.putAll(ItemNetworkAnalyzer.defaultColors);
        for (Map.Entry entry : this.colors.entrySet()) {
            ColorArea btn = (ColorArea)this.colorBtns.get(entry.getKey());
            btn.setColor((ColorData)entry.getValue());
        }
    }

    public void closeColorConfig(boolean save) {
        if (save) {
            ColorArea colorBtn = (ColorArea)this.colorBtns.get(this.colorWindow.configType);
            ColorData newData = this.colorShow.getColor();
            colorBtn.setColor(newData);
            this.colors.put(this.colorWindow.configType, (Object)newData);
        }
        this.colorWindow.isOn = false;
    }

    private void beginColorConfig(Enum<?> type) {
        this.colorWindow.isOn = true;
        this.colorWindow.configType = type;
        ColorData color = ((ColorArea)this.colorBtns.get(type)).getColor();
        this.colorRed.setValue(color.getRf());
        this.colorGreen.setValue(color.getGf());
        this.colorBlue.setValue(color.getBf());
        this.colorAlpha.setValue(color.getAf());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.disableDepthTest();
        for (ClickableArea c : this.clickables) {
            if (!(c instanceof DrawableArea)) continue;
            DrawableArea d = (DrawableArea)c;
            d.draw(guiGraphics);
        }
        if (this.colorWindow.isOn) {
            this.colorShow.setColor(new ColorData(this.colorAlpha.getValue(), this.colorRed.getValue(), this.colorGreen.getValue(), this.colorBlue.getValue()));
            this.colorWindow.draw(guiGraphics);
        }
        RenderSystem.enableDepthTest();
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        if (this.colorWindow.isOn) {
            return this.colorWindow.click(xCoord, yCoord);
        }
        for (ClickableArea c : this.clickables) {
            if (!c.click(xCoord, yCoord)) continue;
            return true;
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.colorWindow.isOn) {
            this.colorWindow.release(mouseX, mouseY);
            return true;
        }
        this.clickables.forEach(c -> c.release(mouseX, mouseY));
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (this.colorWindow.isOn) {
            this.colorWindow.drag(mouseX, mouseY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        this.drawCenteredText(guiGraphics, this.mode.getTranslatedName(), 76, 27, -1);
        this.drawCenteredText(guiGraphics, (Component)Component.translatable((String)"gui.ae2netanalyser.network_analyser.mode"), 24, 26, textColor);
        this.drawCenteredText(guiGraphics, String.valueOf((int)(this.size * 10.0f)), 76, 55, -1);
        this.drawCenteredText(guiGraphics, (Component)Component.translatable((String)"gui.ae2netanalyser.network_analyser.node_size"), 24, 54, textColor);
        this.drawCenteredText(guiGraphics, (Component)Component.translatable((String)"gui.ae2netanalyser.network_analyser.reset"), 179, 149, -1);
        for (int i = 0; i < COLOR_ORDER.size(); ++i) {
            Enum<?> m = COLOR_ORDER.get(i);
            if (m.getClass() == NodeFlag.class) {
                guiGraphics.drawString(this.font, (Component)Component.translatable((String)("gui.ae2netanalyser.network_analyser.NODE." + m.name())), 134, 23 + 21 * i, textColor, false);
            }
            if (m.getClass() != LinkFlag.class) continue;
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)("gui.ae2netanalyser.network_analyser.LINK." + m.name())), 134, 23 + 21 * i, textColor, false);
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)("gui.ae2netanalyser.network_analyser.channel." + Util.getChannelMode().name())), 16, 72, textColor, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.ae2netanalyser.network_analyser.state.normal_nodes", (Object[])new Object[]{this.countNode(NodeFlag.NORMAL)}), 16, 86, -13457341, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.ae2netanalyser.network_analyser.state.dense_nodes", (Object[])new Object[]{this.countNode(NodeFlag.DENSE)}), 16, 100, -15092829, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.ae2netanalyser.network_analyser.state.missing_nodes", (Object[])new Object[]{this.countNode(NodeFlag.MISSING)}), 16, 114, -5629414, false);
    }

    private int countNode(NodeFlag type) {
        NetworkData data = NetworkDataHandler.pullData();
        if (data != null) {
            return data.countNode(type);
        }
        return 0;
    }

    private void drawCenteredText(GuiGraphics guiGraphics, String text, int centerX, int centerY, int color) {
        this.drawCenteredText(guiGraphics, (Component)Component.literal((String)text), centerX, centerY, color);
    }

    private void drawCenteredText(GuiGraphics guiGraphics, Component text, int centerX, int centerY, int color) {
        int width = this.font.width((FormattedText)text);
        Objects.requireNonNull(this.font);
        int height = 9;
        guiGraphics.drawString(this.font, text, centerX - width / 2, centerY - height / 2, color, false);
    }

    private void changeMode(int offset) {
        this.mode = AnalyserMode.byIndex((this.mode.ordinal() + offset + AnalyserMode.values().length) % AnalyserMode.values().length);
    }

    private void changeSize(float offset) {
        this.size += offset;
        this.size = (float)GlodUtil.clamp((double)this.size, (double)0.1, (double)0.9);
    }

    public void onClose() {
        AEANetworkHandler.INSTANCE.sendToServer(new CAnalyserConfigSave(new ItemNetworkAnalyzer.AnalyserConfig(this.mode, this.size, (Map<Enum<?>, ColorData>)this.colors)));
        super.onClose();
    }

    private static class ColorWindow
    extends ClickableArea {
        final List<ClickableArea> elements = new ArrayList<ClickableArea>();
        Enum<?> configType;
        boolean isOn = false;

        public ColorWindow(int x, int y, int width, int height, AbstractContainerScreen<?> parent) {
            super(x, y, width, height, parent, () -> {});
        }

        public void draw(GuiGraphics guiGraphics) {
            if (this.isOn) {
                Blitters.COLOR_SUB_MENU.dest(this.x + this.screen.getGuiLeft(), this.y + this.screen.getGuiTop()).blit(guiGraphics);
                for (ClickableArea c : this.elements) {
                    if (!(c instanceof DrawableArea)) continue;
                    DrawableArea d = (DrawableArea)c;
                    d.draw(guiGraphics);
                }
            }
        }

        public void addElement(ClickableArea c) {
            this.elements.add(c);
        }

        @Override
        public boolean click(double x, double y) {
            if (this.isMouseOver(x, y)) {
                for (ClickableArea c : this.elements) {
                    if (!c.click(x, y)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void release(double x, double y) {
            for (ClickableArea c : this.elements) {
                c.release(x, y);
            }
        }

        public void drag(double x, double y) {
            for (ClickableArea c : this.elements) {
                if (!(c instanceof DraggableArea)) continue;
                DraggableArea d = (DraggableArea)c;
                d.drag(x, y);
            }
        }
    }
}

